<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagingData StructType
 * @subpackage Structs
 */
class PagingData extends AbstractStructBase
{
    /**
     * The currentPage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $currentPage;
    /**
     * The pageSize
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageSize;
    /**
     * The totalCount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $totalCount;
    /**
     * The pageCount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageCount;
    /**
     * Constructor method for PagingData
     * @uses PagingData::setCurrentPage()
     * @uses PagingData::setPageSize()
     * @uses PagingData::setTotalCount()
     * @uses PagingData::setPageCount()
     * @param int $currentPage
     * @param int $pageSize
     * @param int $totalCount
     * @param int $pageCount
     */
    public function __construct($currentPage = null, $pageSize = null, $totalCount = null, $pageCount = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setPageSize($pageSize)
            ->setTotalCount($totalCount)
            ->setPageCount($pageCount);
    }
    /**
     * Get currentPage value
     * @return int|null
     */
    public function getCurrentPage()
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \StructType\PagingData
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !is_numeric($currentPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\PagingData
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\PagingData
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !is_numeric($totalCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get pageCount value
     * @return int|null
     */
    public function getPageCount()
    {
        return $this->pageCount;
    }
    /**
     * Set pageCount value
     * @param int $pageCount
     * @return \StructType\PagingData
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !is_numeric($pageCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageCount)), __LINE__);
        }
        $this->pageCount = $pageCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagingData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
