<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductQuestionDetailRequest StructType
 * @subpackage Structs
 */
class GetProductQuestionDetailRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productQuestionId
     * @var int
     */
    public $productQuestionId;
    /**
     * Constructor method for GetProductQuestionDetailRequest
     * @uses GetProductQuestionDetailRequest::setAuth()
     * @uses GetProductQuestionDetailRequest::setProductQuestionId()
     * @param \StructType\Authentication $auth
     * @param int $productQuestionId
     */
    public function __construct(\StructType\Authentication $auth = null, $productQuestionId = null)
    {
        $this
            ->setAuth($auth)
            ->setProductQuestionId($productQuestionId);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductQuestionDetailRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productQuestionId value
     * @return int|null
     */
    public function getProductQuestionId()
    {
        return $this->productQuestionId;
    }
    /**
     * Set productQuestionId value
     * @param int $productQuestionId
     * @return \StructType\GetProductQuestionDetailRequest
     */
    public function setProductQuestionId($productQuestionId = null)
    {
        // validation for constraint: int
        if (!is_null($productQuestionId) && !is_numeric($productQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productQuestionId)), __LINE__);
        }
        $this->productQuestionId = $productQuestionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductQuestionDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
