<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductByProductIdRequest StructType
 * @subpackage Structs
 */
class GetProductByProductIdRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * Constructor method for GetProductByProductIdRequest
     * @uses GetProductByProductIdRequest::setAuth()
     * @uses GetProductByProductIdRequest::setProductId()
     * @param \StructType\Authentication $auth
     * @param int $productId
     */
    public function __construct(\StructType\Authentication $auth = null, $productId = null)
    {
        $this
            ->setAuth($auth)
            ->setProductId($productId);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductByProductIdRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\GetProductByProductIdRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductByProductIdRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
