<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateProductPriceById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateProductPriceByIdRequest $updateProductPriceByIdRequest
     * @return \StructType\UpdateProductPriceByIdResponse|bool
     */
    public function UpdateProductPriceById(\StructType\UpdateProductPriceByIdRequest $updateProductPriceByIdRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateProductPriceById($updateProductPriceByIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateProductPriceBySellerCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateProductPriceBySellerCodeRequest $updateProductPriceBySellerCodeRequest
     * @return \StructType\UpdateProductPriceBySellerCodeResponse|bool
     */
    public function UpdateProductPriceBySellerCode(\StructType\UpdateProductPriceBySellerCodeRequest $updateProductPriceBySellerCodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateProductPriceBySellerCode($updateProductPriceBySellerCodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateProductBasic
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateProductBasicRequest $updateProductBasicRequest
     * @return \StructType\UpdateProductBasicResponse|bool
     */
    public function UpdateProductBasic(\StructType\UpdateProductBasicRequest $updateProductBasicRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateProductBasic($updateProductBasicRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDiscountValueByProductId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDiscountValueByProductIdRequest $updateDiscountValueByProductIdRequest
     * @return \StructType\UpdateDiscountValueByProductIdResponse|bool
     */
    public function UpdateDiscountValueByProductId(\StructType\UpdateDiscountValueByProductIdRequest $updateDiscountValueByProductIdRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDiscountValueByProductId($updateDiscountValueByProductIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDiscountValueBySellerCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDiscountValueBySellerCodeRequest $updateDiscountValueBySellerCodeRequest
     * @return \StructType\UpdateDiscountValueBySellerCodeResponse|bool
     */
    public function UpdateDiscountValueBySellerCode(\StructType\UpdateDiscountValueBySellerCodeRequest $updateDiscountValueBySellerCodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDiscountValueBySellerCode($updateDiscountValueBySellerCodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateDiscountValueByProductIdResponse|\StructType\UpdateDiscountValueBySellerCodeResponse|\StructType\UpdateProductBasicResponse|\StructType\UpdateProductPriceByIdResponse|\StructType\UpdateProductPriceBySellerCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
