<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithSellerStockCode StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithSellerStockCode extends AbstractStructBase
{
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The quantityToIncrease
     * @var int
     */
    public $quantityToIncrease;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForAddStockWithSellerStockCode
     * @uses StockItemForAddStockWithSellerStockCode::setSellerStockCode()
     * @uses StockItemForAddStockWithSellerStockCode::setQuantityToIncrease()
     * @uses StockItemForAddStockWithSellerStockCode::setVersion()
     * @param string $sellerStockCode
     * @param int $quantityToIncrease
     * @param int $version
     */
    public function __construct($sellerStockCode = null, $quantityToIncrease = null, $version = null)
    {
        $this
            ->setSellerStockCode($sellerStockCode)
            ->setQuantityToIncrease($quantityToIncrease)
            ->setVersion($version);
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get quantityToIncrease value
     * @return int|null
     */
    public function getQuantityToIncrease()
    {
        return $this->quantityToIncrease;
    }
    /**
     * Set quantityToIncrease value
     * @param int $quantityToIncrease
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public function setQuantityToIncrease($quantityToIncrease = null)
    {
        // validation for constraint: int
        if (!is_null($quantityToIncrease) && !is_numeric($quantityToIncrease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantityToIncrease)), __LINE__);
        }
        $this->quantityToIncrease = $quantityToIncrease;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForAddStockWithSellerStockCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
