<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithIdList StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithIdList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForAddStockWithId[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForAddStockWithIdList
     * @uses StockItemForAddStockWithIdList::setStockItem()
     * @param \StructType\StockItemForAddStockWithId[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForAddStockWithId[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithId[] $stockItem
     * @return \StructType\StockItemForAddStockWithIdList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $stockItemForAddStockWithIdListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForAddStockWithIdListStockItemItem instanceof \StructType\StockItemForAddStockWithId) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForAddStockWithId, "%s" given', is_object($stockItemForAddStockWithIdListStockItemItem) ? get_class($stockItemForAddStockWithIdListStockItemItem) : gettype($stockItemForAddStockWithIdListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithId $item
     * @return \StructType\StockItemForAddStockWithIdList
     */
    public function addToStockItem(\StructType\StockItemForAddStockWithId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForAddStockWithId) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForAddStockWithId, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForAddStockWithIdList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
