<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithAttributesList StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithAttributesList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForAddStockWithAttributes[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForAddStockWithAttributesList
     * @uses StockItemForAddStockWithAttributesList::setStockItem()
     * @param \StructType\StockItemForAddStockWithAttributes[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForAddStockWithAttributes[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithAttributes[] $stockItem
     * @return \StructType\StockItemForAddStockWithAttributesList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $stockItemForAddStockWithAttributesListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForAddStockWithAttributesListStockItemItem instanceof \StructType\StockItemForAddStockWithAttributes) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForAddStockWithAttributes, "%s" given', is_object($stockItemForAddStockWithAttributesListStockItemItem) ? get_class($stockItemForAddStockWithAttributesListStockItemItem) : gettype($stockItemForAddStockWithAttributesListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithAttributes $item
     * @return \StructType\StockItemForAddStockWithAttributesList
     */
    public function addToStockItem(\StructType\StockItemForAddStockWithAttributes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForAddStockWithAttributes) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForAddStockWithAttributes, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForAddStockWithAttributesList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
