<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithAttributes StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithAttributes extends AbstractStructBase
{
    /**
     * The attributes
     * @var \StructType\StockAttributeList
     */
    public $attributes;
    /**
     * The quantityToIncrease
     * @var int
     */
    public $quantityToIncrease;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForAddStockWithAttributes
     * @uses StockItemForAddStockWithAttributes::setAttributes()
     * @uses StockItemForAddStockWithAttributes::setQuantityToIncrease()
     * @uses StockItemForAddStockWithAttributes::setVersion()
     * @param \StructType\StockAttributeList $attributes
     * @param int $quantityToIncrease
     * @param int $version
     */
    public function __construct(\StructType\StockAttributeList $attributes = null, $quantityToIncrease = null, $version = null)
    {
        $this
            ->setAttributes($attributes)
            ->setQuantityToIncrease($quantityToIncrease)
            ->setVersion($version);
    }
    /**
     * Get attributes value
     * @return \StructType\StockAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\StockAttributeList $attributes
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public function setAttributes(\StructType\StockAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get quantityToIncrease value
     * @return int|null
     */
    public function getQuantityToIncrease()
    {
        return $this->quantityToIncrease;
    }
    /**
     * Set quantityToIncrease value
     * @param int $quantityToIncrease
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public function setQuantityToIncrease($quantityToIncrease = null)
    {
        // validation for constraint: int
        if (!is_null($quantityToIncrease) && !is_numeric($quantityToIncrease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantityToIncrease)), __LINE__);
        }
        $this->quantityToIncrease = $quantityToIncrease;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForAddStockWithAttributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
