<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockDataWithProductId StructType
 * @subpackage Structs
 */
class StockDataWithProductId extends AbstractStructBase
{
    /**
     * The stockItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemList[]
     */
    public $stockItems;
    /**
     * The product
     * @var \StructType\ProductWithId
     */
    public $product;
    /**
     * Constructor method for StockDataWithProductId
     * @uses StockDataWithProductId::setStockItems()
     * @uses StockDataWithProductId::setProduct()
     * @param \StructType\StockItemList[] $stockItems
     * @param \StructType\ProductWithId $product
     */
    public function __construct(array $stockItems = array(), \StructType\ProductWithId $product = null)
    {
        $this
            ->setStockItems($stockItems)
            ->setProduct($product);
    }
    /**
     * Get stockItems value
     * @return \StructType\StockItemList[]|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemList[] $stockItems
     * @return \StructType\StockDataWithProductId
     */
    public function setStockItems(array $stockItems = array())
    {
        foreach ($stockItems as $stockDataWithProductIdStockItemsItem) {
            // validation for constraint: itemType
            if (!$stockDataWithProductIdStockItemsItem instanceof \StructType\StockItemList) {
                throw new \InvalidArgumentException(sprintf('The stockItems property can only contain items of \StructType\StockItemList, "%s" given', is_object($stockDataWithProductIdStockItemsItem) ? get_class($stockDataWithProductIdStockItemsItem) : gettype($stockDataWithProductIdStockItemsItem)), __LINE__);
            }
        }
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Add item to stockItems value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemList $item
     * @return \StructType\StockDataWithProductId
     */
    public function addToStockItems(\StructType\StockItemList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemList) {
            throw new \InvalidArgumentException(sprintf('The stockItems property can only contain items of \StructType\StockItemList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItems[] = $item;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\ProductWithId|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ProductWithId $product
     * @return \StructType\StockDataWithProductId
     */
    public function setProduct(\StructType\ProductWithId $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockDataWithProductId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
