<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWithSellerCode StructType
 * @subpackage Structs
 */
class ProductWithSellerCode extends AbstractStructBase
{
    /**
     * The sellerCode
     * @var string
     */
    public $sellerCode;
    /**
     * Constructor method for ProductWithSellerCode
     * @uses ProductWithSellerCode::setSellerCode()
     * @param string $sellerCode
     */
    public function __construct($sellerCode = null)
    {
        $this
            ->setSellerCode($sellerCode);
    }
    /**
     * Get sellerCode value
     * @return string|null
     */
    public function getSellerCode()
    {
        return $this->sellerCode;
    }
    /**
     * Set sellerCode value
     * @param string $sellerCode
     * @return \StructType\ProductWithSellerCode
     */
    public function setSellerCode($sellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerCode) && !is_string($sellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerCode)), __LINE__);
        }
        $this->sellerCode = $sellerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductWithSellerCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
