<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWithIdAndStockId StructType
 * @subpackage Structs
 */
class ProductWithIdAndStockId extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockList
     * @var \StructType\StockItemForAddStockWithIdList
     */
    public $stockList;
    /**
     * Constructor method for ProductWithIdAndStockId
     * @uses ProductWithIdAndStockId::setId()
     * @uses ProductWithIdAndStockId::setStockList()
     * @param int $id
     * @param \StructType\StockItemForAddStockWithIdList $stockList
     */
    public function __construct($id = null, \StructType\StockItemForAddStockWithIdList $stockList = null)
    {
        $this
            ->setId($id)
            ->setStockList($stockList);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductWithIdAndStockId
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockList value
     * @return \StructType\StockItemForAddStockWithIdList|null
     */
    public function getStockList()
    {
        return $this->stockList;
    }
    /**
     * Set stockList value
     * @param \StructType\StockItemForAddStockWithIdList $stockList
     * @return \StructType\ProductWithIdAndStockId
     */
    public function setStockList(\StructType\StockItemForAddStockWithIdList $stockList = null)
    {
        $this->stockList = $stockList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductWithIdAndStockId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
