<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasicRequestItemList StructType
 * @subpackage Structs
 */
class ProductSkuBasicRequestItemList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSkuBasicRequest[]
     */
    public $stockItem;
    /**
     * Constructor method for ProductSkuBasicRequestItemList
     * @uses ProductSkuBasicRequestItemList::setStockItem()
     * @param \StructType\ProductSkuBasicRequest[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSkuBasicRequest[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuBasicRequest[] $stockItem
     * @return \StructType\ProductSkuBasicRequestItemList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $productSkuBasicRequestItemListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuBasicRequestItemListStockItemItem instanceof \StructType\ProductSkuBasicRequest) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSkuBasicRequest, "%s" given', is_object($productSkuBasicRequestItemListStockItemItem) ? get_class($productSkuBasicRequestItemListStockItemItem) : gettype($productSkuBasicRequestItemListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuBasicRequest $item
     * @return \StructType\ProductSkuBasicRequestItemList
     */
    public function addToStockItem(\StructType\ProductSkuBasicRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSkuBasicRequest) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSkuBasicRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuBasicRequestItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
