<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasicItemList StructType
 * @subpackage Structs
 */
class ProductSkuBasicItemList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSkuBasic[]
     */
    public $stockItem;
    /**
     * Constructor method for ProductSkuBasicItemList
     * @uses ProductSkuBasicItemList::setStockItem()
     * @param \StructType\ProductSkuBasic[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSkuBasic[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuBasic[] $stockItem
     * @return \StructType\ProductSkuBasicItemList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $productSkuBasicItemListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuBasicItemListStockItemItem instanceof \StructType\ProductSkuBasic) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSkuBasic, "%s" given', is_object($productSkuBasicItemListStockItemItem) ? get_class($productSkuBasicItemListStockItemItem) : gettype($productSkuBasicItemListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSkuBasic $item
     * @return \StructType\ProductSkuBasicItemList
     */
    public function addToStockItem(\StructType\ProductSkuBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSkuBasic) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSkuBasic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuBasicItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
