<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasic StructType
 * @subpackage Structs
 */
class ProductSkuBasic extends ProductSkuBasicRequest
{
    /**
     * The currencyAmount
     * @var float
     */
    public $currencyAmount;
    /**
     * The displayPrice
     * @var float
     */
    public $displayPrice;
    /**
     * The oldOptionPrice
     * @var float
     */
    public $oldOptionPrice;
    /**
     * The gtin
     * @var string
     */
    public $gtin;
    /**
     * The mpn
     * @var string
     */
    public $mpn;
    /**
     * The oem
     * @var string
     */
    public $oem;
    /**
     * The bundle
     * @var bool
     */
    public $bundle;
    /**
     * Constructor method for ProductSkuBasic
     * @uses ProductSkuBasic::setCurrencyAmount()
     * @uses ProductSkuBasic::setDisplayPrice()
     * @uses ProductSkuBasic::setOldOptionPrice()
     * @uses ProductSkuBasic::setGtin()
     * @uses ProductSkuBasic::setMpn()
     * @uses ProductSkuBasic::setOem()
     * @uses ProductSkuBasic::setBundle()
     * @param float $currencyAmount
     * @param float $displayPrice
     * @param float $oldOptionPrice
     * @param string $gtin
     * @param string $mpn
     * @param string $oem
     * @param bool $bundle
     */
    public function __construct($currencyAmount = null, $displayPrice = null, $oldOptionPrice = null, $gtin = null, $mpn = null, $oem = null, $bundle = null)
    {
        $this
            ->setCurrencyAmount($currencyAmount)
            ->setDisplayPrice($displayPrice)
            ->setOldOptionPrice($oldOptionPrice)
            ->setGtin($gtin)
            ->setMpn($mpn)
            ->setOem($oem)
            ->setBundle($bundle);
    }
    /**
     * Get currencyAmount value
     * @return float|null
     */
    public function getCurrencyAmount()
    {
        return $this->currencyAmount;
    }
    /**
     * Set currencyAmount value
     * @param float $currencyAmount
     * @return \StructType\ProductSkuBasic
     */
    public function setCurrencyAmount($currencyAmount = null)
    {
        $this->currencyAmount = $currencyAmount;
        return $this;
    }
    /**
     * Get displayPrice value
     * @return float|null
     */
    public function getDisplayPrice()
    {
        return $this->displayPrice;
    }
    /**
     * Set displayPrice value
     * @param float $displayPrice
     * @return \StructType\ProductSkuBasic
     */
    public function setDisplayPrice($displayPrice = null)
    {
        $this->displayPrice = $displayPrice;
        return $this;
    }
    /**
     * Get oldOptionPrice value
     * @return float|null
     */
    public function getOldOptionPrice()
    {
        return $this->oldOptionPrice;
    }
    /**
     * Set oldOptionPrice value
     * @param float $oldOptionPrice
     * @return \StructType\ProductSkuBasic
     */
    public function setOldOptionPrice($oldOptionPrice = null)
    {
        $this->oldOptionPrice = $oldOptionPrice;
        return $this;
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\ProductSkuBasic
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
    /**
     * Get mpn value
     * @return string|null
     */
    public function getMpn()
    {
        return $this->mpn;
    }
    /**
     * Set mpn value
     * @param string $mpn
     * @return \StructType\ProductSkuBasic
     */
    public function setMpn($mpn = null)
    {
        // validation for constraint: string
        if (!is_null($mpn) && !is_string($mpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpn)), __LINE__);
        }
        $this->mpn = $mpn;
        return $this;
    }
    /**
     * Get oem value
     * @return string|null
     */
    public function getOem()
    {
        return $this->oem;
    }
    /**
     * Set oem value
     * @param string $oem
     * @return \StructType\ProductSkuBasic
     */
    public function setOem($oem = null)
    {
        // validation for constraint: string
        if (!is_null($oem) && !is_string($oem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oem)), __LINE__);
        }
        $this->oem = $oem;
        return $this;
    }
    /**
     * Get bundle value
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param bool $bundle
     * @return \StructType\ProductSkuBasic
     */
    public function setBundle($bundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundle) && !is_bool($bundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bundle)), __LINE__);
        }
        $this->bundle = $bundle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuBasic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
