<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductRequest StructType
 * @subpackage Structs
 */
class ProductRequest extends AbstractStructBase
{
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The subtitle
     * @var string
     */
    public $subtitle;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The category
     * @var \StructType\CategoryRequest
     */
    public $category;
    /**
     * The specialProductInfoList
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpecialProductInfoList
     */
    public $specialProductInfoList;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * The images
     * @var \StructType\ProductImageList
     */
    public $images;
    /**
     * The approvalStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $approvalStatus;
    /**
     * The attributes
     * @var \StructType\ProductAttributeRequestList
     */
    public $attributes;
    /**
     * The saleStartDate
     * @var string
     */
    public $saleStartDate;
    /**
     * The saleEndDate
     * @var string
     */
    public $saleEndDate;
    /**
     * The productionDate
     * @var string
     */
    public $productionDate;
    /**
     * The expirationDate
     * @var string
     */
    public $expirationDate;
    /**
     * The productCondition
     * @var string
     */
    public $productCondition;
    /**
     * The preparingDay
     * @var int
     */
    public $preparingDay;
    /**
     * The discount
     * @var \StructType\ProductDiscountRequest
     */
    public $discount;
    /**
     * The shipmentTemplate
     * @var string
     */
    public $shipmentTemplate;
    /**
     * The stockItems
     * @var \StructType\ProductSkuRequestList
     */
    public $stockItems;
    /**
     * Constructor method for ProductRequest
     * @uses ProductRequest::setProductSellerCode()
     * @uses ProductRequest::setTitle()
     * @uses ProductRequest::setSubtitle()
     * @uses ProductRequest::setDescription()
     * @uses ProductRequest::setCategory()
     * @uses ProductRequest::setSpecialProductInfoList()
     * @uses ProductRequest::setPrice()
     * @uses ProductRequest::setCurrencyType()
     * @uses ProductRequest::setImages()
     * @uses ProductRequest::setApprovalStatus()
     * @uses ProductRequest::setAttributes()
     * @uses ProductRequest::setSaleStartDate()
     * @uses ProductRequest::setSaleEndDate()
     * @uses ProductRequest::setProductionDate()
     * @uses ProductRequest::setExpirationDate()
     * @uses ProductRequest::setProductCondition()
     * @uses ProductRequest::setPreparingDay()
     * @uses ProductRequest::setDiscount()
     * @uses ProductRequest::setShipmentTemplate()
     * @uses ProductRequest::setStockItems()
     * @param string $productSellerCode
     * @param string $title
     * @param string $subtitle
     * @param string $description
     * @param \StructType\CategoryRequest $category
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @param float $price
     * @param int $currencyType
     * @param \StructType\ProductImageList $images
     * @param int $approvalStatus
     * @param \StructType\ProductAttributeRequestList $attributes
     * @param string $saleStartDate
     * @param string $saleEndDate
     * @param string $productionDate
     * @param string $expirationDate
     * @param string $productCondition
     * @param int $preparingDay
     * @param \StructType\ProductDiscountRequest $discount
     * @param string $shipmentTemplate
     * @param \StructType\ProductSkuRequestList $stockItems
     */
    public function __construct($productSellerCode = null, $title = null, $subtitle = null, $description = null, \StructType\CategoryRequest $category = null, \StructType\SpecialProductInfoList $specialProductInfoList = null, $price = null, $currencyType = null, \StructType\ProductImageList $images = null, $approvalStatus = null, \StructType\ProductAttributeRequestList $attributes = null, $saleStartDate = null, $saleEndDate = null, $productionDate = null, $expirationDate = null, $productCondition = null, $preparingDay = null, \StructType\ProductDiscountRequest $discount = null, $shipmentTemplate = null, \StructType\ProductSkuRequestList $stockItems = null)
    {
        $this
            ->setProductSellerCode($productSellerCode)
            ->setTitle($title)
            ->setSubtitle($subtitle)
            ->setDescription($description)
            ->setCategory($category)
            ->setSpecialProductInfoList($specialProductInfoList)
            ->setPrice($price)
            ->setCurrencyType($currencyType)
            ->setImages($images)
            ->setApprovalStatus($approvalStatus)
            ->setAttributes($attributes)
            ->setSaleStartDate($saleStartDate)
            ->setSaleEndDate($saleEndDate)
            ->setProductionDate($productionDate)
            ->setExpirationDate($expirationDate)
            ->setProductCondition($productCondition)
            ->setPreparingDay($preparingDay)
            ->setDiscount($discount)
            ->setShipmentTemplate($shipmentTemplate)
            ->setStockItems($stockItems);
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\ProductRequest
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ProductRequest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get subtitle value
     * @return string|null
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }
    /**
     * Set subtitle value
     * @param string $subtitle
     * @return \StructType\ProductRequest
     */
    public function setSubtitle($subtitle = null)
    {
        // validation for constraint: string
        if (!is_null($subtitle) && !is_string($subtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subtitle)), __LINE__);
        }
        $this->subtitle = $subtitle;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ProductRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\CategoryRequest|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\CategoryRequest $category
     * @return \StructType\ProductRequest
     */
    public function setCategory(\StructType\CategoryRequest $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get specialProductInfoList value
     * @return \StructType\SpecialProductInfoList|null
     */
    public function getSpecialProductInfoList()
    {
        return $this->specialProductInfoList;
    }
    /**
     * Set specialProductInfoList value
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @return \StructType\ProductRequest
     */
    public function setSpecialProductInfoList(\StructType\SpecialProductInfoList $specialProductInfoList = null)
    {
        $this->specialProductInfoList = $specialProductInfoList;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductRequest
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\ProductRequest
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !is_numeric($currencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageList $images
     * @return \StructType\ProductRequest
     */
    public function setImages(\StructType\ProductImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return int|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param int $approvalStatus
     * @return \StructType\ProductRequest
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($approvalStatus) && !is_numeric($approvalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($approvalStatus)), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeRequestList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeRequestList $attributes
     * @return \StructType\ProductRequest
     */
    public function setAttributes(\StructType\ProductAttributeRequestList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get saleStartDate value
     * @return string|null
     */
    public function getSaleStartDate()
    {
        return $this->saleStartDate;
    }
    /**
     * Set saleStartDate value
     * @param string $saleStartDate
     * @return \StructType\ProductRequest
     */
    public function setSaleStartDate($saleStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleStartDate) && !is_string($saleStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleStartDate)), __LINE__);
        }
        $this->saleStartDate = $saleStartDate;
        return $this;
    }
    /**
     * Get saleEndDate value
     * @return string|null
     */
    public function getSaleEndDate()
    {
        return $this->saleEndDate;
    }
    /**
     * Set saleEndDate value
     * @param string $saleEndDate
     * @return \StructType\ProductRequest
     */
    public function setSaleEndDate($saleEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleEndDate) && !is_string($saleEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleEndDate)), __LINE__);
        }
        $this->saleEndDate = $saleEndDate;
        return $this;
    }
    /**
     * Get productionDate value
     * @return string|null
     */
    public function getProductionDate()
    {
        return $this->productionDate;
    }
    /**
     * Set productionDate value
     * @param string $productionDate
     * @return \StructType\ProductRequest
     */
    public function setProductionDate($productionDate = null)
    {
        // validation for constraint: string
        if (!is_null($productionDate) && !is_string($productionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productionDate)), __LINE__);
        }
        $this->productionDate = $productionDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\ProductRequest
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get productCondition value
     * @return string|null
     */
    public function getProductCondition()
    {
        return $this->productCondition;
    }
    /**
     * Set productCondition value
     * @param string $productCondition
     * @return \StructType\ProductRequest
     */
    public function setProductCondition($productCondition = null)
    {
        // validation for constraint: string
        if (!is_null($productCondition) && !is_string($productCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCondition)), __LINE__);
        }
        $this->productCondition = $productCondition;
        return $this;
    }
    /**
     * Get preparingDay value
     * @return int|null
     */
    public function getPreparingDay()
    {
        return $this->preparingDay;
    }
    /**
     * Set preparingDay value
     * @param int $preparingDay
     * @return \StructType\ProductRequest
     */
    public function setPreparingDay($preparingDay = null)
    {
        // validation for constraint: int
        if (!is_null($preparingDay) && !is_numeric($preparingDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preparingDay)), __LINE__);
        }
        $this->preparingDay = $preparingDay;
        return $this;
    }
    /**
     * Get discount value
     * @return \StructType\ProductDiscountRequest|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param \StructType\ProductDiscountRequest $discount
     * @return \StructType\ProductRequest
     */
    public function setDiscount(\StructType\ProductDiscountRequest $discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get shipmentTemplate value
     * @return string|null
     */
    public function getShipmentTemplate()
    {
        return $this->shipmentTemplate;
    }
    /**
     * Set shipmentTemplate value
     * @param string $shipmentTemplate
     * @return \StructType\ProductRequest
     */
    public function setShipmentTemplate($shipmentTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentTemplate) && !is_string($shipmentTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentTemplate)), __LINE__);
        }
        $this->shipmentTemplate = $shipmentTemplate;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuRequestList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuRequestList $stockItems
     * @return \StructType\ProductRequest
     */
    public function setStockItems(\StructType\ProductSkuRequestList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
