<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductImageList StructType
 * @subpackage Structs
 */
class ProductImageList extends AbstractStructBase
{
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductImage[]
     */
    public $image;
    /**
     * Constructor method for ProductImageList
     * @uses ProductImageList::setImage()
     * @param \StructType\ProductImage[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get image value
     * @return \StructType\ProductImage[]|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductImage[] $image
     * @return \StructType\ProductImageList
     */
    public function setImage(array $image = array())
    {
        foreach ($image as $productImageListImageItem) {
            // validation for constraint: itemType
            if (!$productImageListImageItem instanceof \StructType\ProductImage) {
                throw new \InvalidArgumentException(sprintf('The image property can only contain items of \StructType\ProductImage, "%s" given', is_object($productImageListImageItem) ? get_class($productImageListImageItem) : gettype($productImageListImageItem)), __LINE__);
            }
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Add item to image value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductImage $item
     * @return \StructType\ProductImageList
     */
    public function addToImage(\StructType\ProductImage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductImage) {
            throw new \InvalidArgumentException(sprintf('The image property can only contain items of \StructType\ProductImage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->image[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductImageList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
