<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductBasic StructType
 * @subpackage Structs
 */
class ProductBasic extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The subtitle
     * @var string
     */
    public $subtitle;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The displayPrice
     * @var float
     */
    public $displayPrice;
    /**
     * The saleStatus
     * @var int
     */
    public $saleStatus;
    /**
     * The approvalStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $approvalStatus;
    /**
     * The stockItems
     * @var \StructType\ProductSkuList
     */
    public $stockItems;
    /**
     * The oldPrice
     * @var float
     */
    public $oldPrice;
    /**
     * The currencyAmount
     * @var float
     */
    public $currencyAmount;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * Constructor method for ProductBasic
     * @uses ProductBasic::setId()
     * @uses ProductBasic::setProductSellerCode()
     * @uses ProductBasic::setTitle()
     * @uses ProductBasic::setSubtitle()
     * @uses ProductBasic::setPrice()
     * @uses ProductBasic::setDisplayPrice()
     * @uses ProductBasic::setSaleStatus()
     * @uses ProductBasic::setApprovalStatus()
     * @uses ProductBasic::setStockItems()
     * @uses ProductBasic::setOldPrice()
     * @uses ProductBasic::setCurrencyAmount()
     * @uses ProductBasic::setCurrencyType()
     * @param int $id
     * @param string $productSellerCode
     * @param string $title
     * @param string $subtitle
     * @param float $price
     * @param float $displayPrice
     * @param int $saleStatus
     * @param int $approvalStatus
     * @param \StructType\ProductSkuList $stockItems
     * @param float $oldPrice
     * @param float $currencyAmount
     * @param int $currencyType
     */
    public function __construct($id = null, $productSellerCode = null, $title = null, $subtitle = null, $price = null, $displayPrice = null, $saleStatus = null, $approvalStatus = null, \StructType\ProductSkuList $stockItems = null, $oldPrice = null, $currencyAmount = null, $currencyType = null)
    {
        $this
            ->setId($id)
            ->setProductSellerCode($productSellerCode)
            ->setTitle($title)
            ->setSubtitle($subtitle)
            ->setPrice($price)
            ->setDisplayPrice($displayPrice)
            ->setSaleStatus($saleStatus)
            ->setApprovalStatus($approvalStatus)
            ->setStockItems($stockItems)
            ->setOldPrice($oldPrice)
            ->setCurrencyAmount($currencyAmount)
            ->setCurrencyType($currencyType);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductBasic
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\ProductBasic
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ProductBasic
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get subtitle value
     * @return string|null
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }
    /**
     * Set subtitle value
     * @param string $subtitle
     * @return \StructType\ProductBasic
     */
    public function setSubtitle($subtitle = null)
    {
        // validation for constraint: string
        if (!is_null($subtitle) && !is_string($subtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subtitle)), __LINE__);
        }
        $this->subtitle = $subtitle;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductBasic
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get displayPrice value
     * @return float|null
     */
    public function getDisplayPrice()
    {
        return $this->displayPrice;
    }
    /**
     * Set displayPrice value
     * @param float $displayPrice
     * @return \StructType\ProductBasic
     */
    public function setDisplayPrice($displayPrice = null)
    {
        $this->displayPrice = $displayPrice;
        return $this;
    }
    /**
     * Get saleStatus value
     * @return int|null
     */
    public function getSaleStatus()
    {
        return $this->saleStatus;
    }
    /**
     * Set saleStatus value
     * @param int $saleStatus
     * @return \StructType\ProductBasic
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: int
        if (!is_null($saleStatus) && !is_numeric($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($saleStatus)), __LINE__);
        }
        $this->saleStatus = $saleStatus;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return int|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param int $approvalStatus
     * @return \StructType\ProductBasic
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($approvalStatus) && !is_numeric($approvalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($approvalStatus)), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuList $stockItems
     * @return \StructType\ProductBasic
     */
    public function setStockItems(\StructType\ProductSkuList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get oldPrice value
     * @return float|null
     */
    public function getOldPrice()
    {
        return $this->oldPrice;
    }
    /**
     * Set oldPrice value
     * @param float $oldPrice
     * @return \StructType\ProductBasic
     */
    public function setOldPrice($oldPrice = null)
    {
        $this->oldPrice = $oldPrice;
        return $this;
    }
    /**
     * Get currencyAmount value
     * @return float|null
     */
    public function getCurrencyAmount()
    {
        return $this->currencyAmount;
    }
    /**
     * Set currencyAmount value
     * @param float $currencyAmount
     * @return \StructType\ProductBasic
     */
    public function setCurrencyAmount($currencyAmount = null)
    {
        $this->currencyAmount = $currencyAmount;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\ProductBasic
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !is_numeric($currencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductBasic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
