<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAttributeList StructType
 * @subpackage Structs
 */
class ProductAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductAttribute[]
     */
    public $attribute;
    /**
     * Constructor method for ProductAttributeList
     * @uses ProductAttributeList::setAttribute()
     * @param \StructType\ProductAttribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\ProductAttribute[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttribute[] $attribute
     * @return \StructType\ProductAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        foreach ($attribute as $productAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$productAttributeListAttributeItem instanceof \StructType\ProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\ProductAttribute, "%s" given', is_object($productAttributeListAttributeItem) ? get_class($productAttributeListAttributeItem) : gettype($productAttributeListAttributeItem)), __LINE__);
            }
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttribute $item
     * @return \StructType\ProductAttributeList
     */
    public function addToAttribute(\StructType\ProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\ProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductAttributeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
