<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The subtitle
     * @var string
     */
    public $subtitle;
    /**
     * The displayPrice
     * @var float
     */
    public $displayPrice;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The category
     * @var \StructType\Category
     */
    public $category;
    /**
     * The specialProductInfoList
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpecialProductInfoList
     */
    public $specialProductInfoList;
    /**
     * The preparingDay
     * @var int
     */
    public $preparingDay;
    /**
     * The saleStartDate
     * @var string
     */
    public $saleStartDate;
    /**
     * The saleEndDate
     * @var string
     */
    public $saleEndDate;
    /**
     * The productCondition
     * @var string
     */
    public $productCondition;
    /**
     * The expirationDate
     * @var string
     */
    public $expirationDate;
    /**
     * The images
     * @var \StructType\ProductImageList
     */
    public $images;
    /**
     * The stockItems
     * @var \StructType\ProductSkuList
     */
    public $stockItems;
    /**
     * The discount
     * @var \StructType\ProductDiscount
     */
    public $discount;
    /**
     * The shipmentTemplate
     * @var string
     */
    public $shipmentTemplate;
    /**
     * The attributes
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ProductAttributeList
     */
    public $attributes;
    /**
     * The approvalStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $approvalStatus;
    /**
     * The saleStatus
     * @var int
     */
    public $saleStatus;
    /**
     * The currencyAmount
     * @var float
     */
    public $currencyAmount;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * Constructor method for Product
     * @uses Product::setId()
     * @uses Product::setTitle()
     * @uses Product::setSubtitle()
     * @uses Product::setDisplayPrice()
     * @uses Product::setPrice()
     * @uses Product::setProductSellerCode()
     * @uses Product::setDescription()
     * @uses Product::setCategory()
     * @uses Product::setSpecialProductInfoList()
     * @uses Product::setPreparingDay()
     * @uses Product::setSaleStartDate()
     * @uses Product::setSaleEndDate()
     * @uses Product::setProductCondition()
     * @uses Product::setExpirationDate()
     * @uses Product::setImages()
     * @uses Product::setStockItems()
     * @uses Product::setDiscount()
     * @uses Product::setShipmentTemplate()
     * @uses Product::setAttributes()
     * @uses Product::setApprovalStatus()
     * @uses Product::setSaleStatus()
     * @uses Product::setCurrencyAmount()
     * @uses Product::setCurrencyType()
     * @param int $id
     * @param string $title
     * @param string $subtitle
     * @param float $displayPrice
     * @param float $price
     * @param string $productSellerCode
     * @param string $description
     * @param \StructType\Category $category
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @param int $preparingDay
     * @param string $saleStartDate
     * @param string $saleEndDate
     * @param string $productCondition
     * @param string $expirationDate
     * @param \StructType\ProductImageList $images
     * @param \StructType\ProductSkuList $stockItems
     * @param \StructType\ProductDiscount $discount
     * @param string $shipmentTemplate
     * @param \StructType\ProductAttributeList $attributes
     * @param int $approvalStatus
     * @param int $saleStatus
     * @param float $currencyAmount
     * @param int $currencyType
     */
    public function __construct($id = null, $title = null, $subtitle = null, $displayPrice = null, $price = null, $productSellerCode = null, $description = null, \StructType\Category $category = null, \StructType\SpecialProductInfoList $specialProductInfoList = null, $preparingDay = null, $saleStartDate = null, $saleEndDate = null, $productCondition = null, $expirationDate = null, \StructType\ProductImageList $images = null, \StructType\ProductSkuList $stockItems = null, \StructType\ProductDiscount $discount = null, $shipmentTemplate = null, \StructType\ProductAttributeList $attributes = null, $approvalStatus = null, $saleStatus = null, $currencyAmount = null, $currencyType = null)
    {
        $this
            ->setId($id)
            ->setTitle($title)
            ->setSubtitle($subtitle)
            ->setDisplayPrice($displayPrice)
            ->setPrice($price)
            ->setProductSellerCode($productSellerCode)
            ->setDescription($description)
            ->setCategory($category)
            ->setSpecialProductInfoList($specialProductInfoList)
            ->setPreparingDay($preparingDay)
            ->setSaleStartDate($saleStartDate)
            ->setSaleEndDate($saleEndDate)
            ->setProductCondition($productCondition)
            ->setExpirationDate($expirationDate)
            ->setImages($images)
            ->setStockItems($stockItems)
            ->setDiscount($discount)
            ->setShipmentTemplate($shipmentTemplate)
            ->setAttributes($attributes)
            ->setApprovalStatus($approvalStatus)
            ->setSaleStatus($saleStatus)
            ->setCurrencyAmount($currencyAmount)
            ->setCurrencyType($currencyType);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Product
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Product
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get subtitle value
     * @return string|null
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }
    /**
     * Set subtitle value
     * @param string $subtitle
     * @return \StructType\Product
     */
    public function setSubtitle($subtitle = null)
    {
        // validation for constraint: string
        if (!is_null($subtitle) && !is_string($subtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subtitle)), __LINE__);
        }
        $this->subtitle = $subtitle;
        return $this;
    }
    /**
     * Get displayPrice value
     * @return float|null
     */
    public function getDisplayPrice()
    {
        return $this->displayPrice;
    }
    /**
     * Set displayPrice value
     * @param float $displayPrice
     * @return \StructType\Product
     */
    public function setDisplayPrice($displayPrice = null)
    {
        $this->displayPrice = $displayPrice;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\Product
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\Product
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Product
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\Category|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\Category $category
     * @return \StructType\Product
     */
    public function setCategory(\StructType\Category $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get specialProductInfoList value
     * @return \StructType\SpecialProductInfoList|null
     */
    public function getSpecialProductInfoList()
    {
        return $this->specialProductInfoList;
    }
    /**
     * Set specialProductInfoList value
     * @param \StructType\SpecialProductInfoList $specialProductInfoList
     * @return \StructType\Product
     */
    public function setSpecialProductInfoList(\StructType\SpecialProductInfoList $specialProductInfoList = null)
    {
        $this->specialProductInfoList = $specialProductInfoList;
        return $this;
    }
    /**
     * Get preparingDay value
     * @return int|null
     */
    public function getPreparingDay()
    {
        return $this->preparingDay;
    }
    /**
     * Set preparingDay value
     * @param int $preparingDay
     * @return \StructType\Product
     */
    public function setPreparingDay($preparingDay = null)
    {
        // validation for constraint: int
        if (!is_null($preparingDay) && !is_numeric($preparingDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preparingDay)), __LINE__);
        }
        $this->preparingDay = $preparingDay;
        return $this;
    }
    /**
     * Get saleStartDate value
     * @return string|null
     */
    public function getSaleStartDate()
    {
        return $this->saleStartDate;
    }
    /**
     * Set saleStartDate value
     * @param string $saleStartDate
     * @return \StructType\Product
     */
    public function setSaleStartDate($saleStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleStartDate) && !is_string($saleStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleStartDate)), __LINE__);
        }
        $this->saleStartDate = $saleStartDate;
        return $this;
    }
    /**
     * Get saleEndDate value
     * @return string|null
     */
    public function getSaleEndDate()
    {
        return $this->saleEndDate;
    }
    /**
     * Set saleEndDate value
     * @param string $saleEndDate
     * @return \StructType\Product
     */
    public function setSaleEndDate($saleEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleEndDate) && !is_string($saleEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleEndDate)), __LINE__);
        }
        $this->saleEndDate = $saleEndDate;
        return $this;
    }
    /**
     * Get productCondition value
     * @return string|null
     */
    public function getProductCondition()
    {
        return $this->productCondition;
    }
    /**
     * Set productCondition value
     * @param string $productCondition
     * @return \StructType\Product
     */
    public function setProductCondition($productCondition = null)
    {
        // validation for constraint: string
        if (!is_null($productCondition) && !is_string($productCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCondition)), __LINE__);
        }
        $this->productCondition = $productCondition;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\Product
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageList $images
     * @return \StructType\Product
     */
    public function setImages(\StructType\ProductImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuList $stockItems
     * @return \StructType\Product
     */
    public function setStockItems(\StructType\ProductSkuList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get discount value
     * @return \StructType\ProductDiscount|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param \StructType\ProductDiscount $discount
     * @return \StructType\Product
     */
    public function setDiscount(\StructType\ProductDiscount $discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get shipmentTemplate value
     * @return string|null
     */
    public function getShipmentTemplate()
    {
        return $this->shipmentTemplate;
    }
    /**
     * Set shipmentTemplate value
     * @param string $shipmentTemplate
     * @return \StructType\Product
     */
    public function setShipmentTemplate($shipmentTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentTemplate) && !is_string($shipmentTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentTemplate)), __LINE__);
        }
        $this->shipmentTemplate = $shipmentTemplate;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeList $attributes
     * @return \StructType\Product
     */
    public function setAttributes(\StructType\ProductAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return int|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param int $approvalStatus
     * @return \StructType\Product
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: int
        if (!is_null($approvalStatus) && !is_numeric($approvalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($approvalStatus)), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get saleStatus value
     * @return int|null
     */
    public function getSaleStatus()
    {
        return $this->saleStatus;
    }
    /**
     * Set saleStatus value
     * @param int $saleStatus
     * @return \StructType\Product
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: int
        if (!is_null($saleStatus) && !is_numeric($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($saleStatus)), __LINE__);
        }
        $this->saleStatus = $saleStatus;
        return $this;
    }
    /**
     * Get currencyAmount value
     * @return float|null
     */
    public function getCurrencyAmount()
    {
        return $this->currencyAmount;
    }
    /**
     * Set currencyAmount value
     * @param float $currencyAmount
     * @return \StructType\Product
     */
    public function setCurrencyAmount($currencyAmount = null)
    {
        $this->currencyAmount = $currencyAmount;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\Product
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !is_numeric($currencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
