<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductQuestionListRequest StructType
 * @subpackage Structs
 */
class GetProductQuestionListRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productQuestionSearch
     * @var \StructType\ProductQuestionSearch
     */
    public $productQuestionSearch;
    /**
     * The pagingData
     * @var \StructType\RequestPagingData
     */
    public $pagingData;
    /**
     * Constructor method for GetProductQuestionListRequest
     * @uses GetProductQuestionListRequest::setAuth()
     * @uses GetProductQuestionListRequest::setProductQuestionSearch()
     * @uses GetProductQuestionListRequest::setPagingData()
     * @param \StructType\Authentication $auth
     * @param \StructType\ProductQuestionSearch $productQuestionSearch
     * @param \StructType\RequestPagingData $pagingData
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\ProductQuestionSearch $productQuestionSearch = null, \StructType\RequestPagingData $pagingData = null)
    {
        $this
            ->setAuth($auth)
            ->setProductQuestionSearch($productQuestionSearch)
            ->setPagingData($pagingData);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductQuestionListRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productQuestionSearch value
     * @return \StructType\ProductQuestionSearch|null
     */
    public function getProductQuestionSearch()
    {
        return $this->productQuestionSearch;
    }
    /**
     * Set productQuestionSearch value
     * @param \StructType\ProductQuestionSearch $productQuestionSearch
     * @return \StructType\GetProductQuestionListRequest
     */
    public function setProductQuestionSearch(\StructType\ProductQuestionSearch $productQuestionSearch = null)
    {
        $this->productQuestionSearch = $productQuestionSearch;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\RequestPagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\RequestPagingData $pagingData
     * @return \StructType\GetProductQuestionListRequest
     */
    public function setPagingData(\StructType\RequestPagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductQuestionListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
