<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductListResponse StructType
 * @subpackage Structs
 */
class GetProductListResponse extends AbstractStructBase
{
    /**
     * The result
     * @var \StructType\ResultInfo
     */
    public $result;
    /**
     * The products
     * @var \StructType\ProductBasicList
     */
    public $products;
    /**
     * The pagingData
     * @var \StructType\PagingData
     */
    public $pagingData;
    /**
     * Constructor method for GetProductListResponse
     * @uses GetProductListResponse::setResult()
     * @uses GetProductListResponse::setProducts()
     * @uses GetProductListResponse::setPagingData()
     * @param \StructType\ResultInfo $result
     * @param \StructType\ProductBasicList $products
     * @param \StructType\PagingData $pagingData
     */
    public function __construct(\StructType\ResultInfo $result = null, \StructType\ProductBasicList $products = null, \StructType\PagingData $pagingData = null)
    {
        $this
            ->setResult($result)
            ->setProducts($products)
            ->setPagingData($pagingData);
    }
    /**
     * Get result value
     * @return \StructType\ResultInfo|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultInfo $result
     * @return \StructType\GetProductListResponse
     */
    public function setResult(\StructType\ResultInfo $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get products value
     * @return \StructType\ProductBasicList|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @param \StructType\ProductBasicList $products
     * @return \StructType\GetProductListResponse
     */
    public function setProducts(\StructType\ProductBasicList $products = null)
    {
        $this->products = $products;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\PagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\PagingData $pagingData
     * @return \StructType\GetProductListResponse
     */
    public function setPagingData(\StructType\PagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
