<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductListRequest StructType
 * @subpackage Structs
 */
class GetProductListRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The pagingData
     * @var \StructType\RequestPagingData
     */
    public $pagingData;
    /**
     * Constructor method for GetProductListRequest
     * @uses GetProductListRequest::setAuth()
     * @uses GetProductListRequest::setPagingData()
     * @param \StructType\Authentication $auth
     * @param \StructType\RequestPagingData $pagingData
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\RequestPagingData $pagingData = null)
    {
        $this
            ->setAuth($auth)
            ->setPagingData($pagingData);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetProductListRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\RequestPagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\RequestPagingData $pagingData
     * @return \StructType\GetProductListRequest
     */
    public function setPagingData(\StructType\RequestPagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
