<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteProductById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteProductByIdRequest $deleteProductByIdRequest
     * @return \StructType\DeleteProductByIdResponse|bool
     */
    public function DeleteProductById(\StructType\DeleteProductByIdRequest $deleteProductByIdRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteProductById($deleteProductByIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteProductBySellerCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteProductBySellerCodeRequest $deleteProductBySellerCodeRequest
     * @return \StructType\DeleteProductBySellerCodeResponse|bool
     */
    public function DeleteProductBySellerCode(\StructType\DeleteProductBySellerCodeRequest $deleteProductBySellerCodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteProductBySellerCode($deleteProductBySellerCodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteProductByIdResponse|\StructType\DeleteProductBySellerCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
