<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadLONXmlResponse StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadLONXmlResponse extends AbstractStructBase
{
    /**
     * The UploadLONXmlResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $UploadLONXmlResult;
    /**
     * Constructor method for UploadLONXmlResponse
     * @uses LendingQBUploadLONXmlResponse::setUploadLONXmlResult()
     * @param string $uploadLONXmlResult
     */
    public function __construct($uploadLONXmlResult = null)
    {
        $this
            ->setUploadLONXmlResult($uploadLONXmlResult);
    }
    /**
     * Get UploadLONXmlResult value
     * @return string
     */
    public function getUploadLONXmlResult()
    {
        return $this->UploadLONXmlResult;
    }
    /**
     * Set UploadLONXmlResult value
     * @param string $uploadLONXmlResult
     * @return \LendingQB\StructType\LendingQBUploadLONXmlResponse
     */
    public function setUploadLONXmlResult($uploadLONXmlResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uploadLONXmlResult) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $uploadLONXmlResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($uploadLONXmlResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uploadLONXmlResult) && !is_string($uploadLONXmlResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uploadLONXmlResult)), __LINE__);
        }
        $this->UploadLONXmlResult = $uploadLONXmlResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBUploadLONXmlResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
