<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskEdit StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBTaskEdit extends AbstractStructBase
{
    /**
     * The sTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The taskId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $taskId;
    /**
     * The subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subject;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The dueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The assignedTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $assignedTo;
    /**
     * Constructor method for TaskEdit
     * @uses LendingQBTaskEdit::setSTicket()
     * @uses LendingQBTaskEdit::setTaskId()
     * @uses LendingQBTaskEdit::setSubject()
     * @uses LendingQBTaskEdit::setComment()
     * @uses LendingQBTaskEdit::setDueDate()
     * @uses LendingQBTaskEdit::setAssignedTo()
     * @param string $sTicket
     * @param string $taskId
     * @param string $subject
     * @param string $comment
     * @param string $dueDate
     * @param string $assignedTo
     */
    public function __construct($sTicket = null, $taskId = null, $subject = null, $comment = null, $dueDate = null, $assignedTo = null)
    {
        $this
            ->setSTicket($sTicket)
            ->setTaskId($taskId)
            ->setSubject($subject)
            ->setComment($comment)
            ->setDueDate($dueDate)
            ->setAssignedTo($assignedTo);
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get taskId value
     * @return string|null
     */
    public function getTaskId()
    {
        return $this->taskId;
    }
    /**
     * Set taskId value
     * @param string $taskId
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public function setTaskId($taskId = null)
    {
        // validation for constraint: string
        if (!is_null($taskId) && !is_string($taskId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taskId)), __LINE__);
        }
        $this->taskId = $taskId;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get assignedTo value
     * @return string|null
     */
    public function getAssignedTo()
    {
        return $this->assignedTo;
    }
    /**
     * Set assignedTo value
     * @param string $assignedTo
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public function setAssignedTo($assignedTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignedTo) && !is_string($assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignedTo)), __LINE__);
        }
        $this->assignedTo = $assignedTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBTaskEdit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
