<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveMismo23 StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBSaveMismo23 extends AbstractStructBase
{
    /**
     * The loanId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $loanId;
    /**
     * The sTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sXmlData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sXmlData;
    /**
     * Constructor method for SaveMismo23
     * @uses LendingQBSaveMismo23::setLoanId()
     * @uses LendingQBSaveMismo23::setSTicket()
     * @uses LendingQBSaveMismo23::setSXmlData()
     * @param string $loanId
     * @param string $sTicket
     * @param string $sXmlData
     */
    public function __construct($loanId = null, $sTicket = null, $sXmlData = null)
    {
        $this
            ->setLoanId($loanId)
            ->setSTicket($sTicket)
            ->setSXmlData($sXmlData);
    }
    /**
     * Get loanId value
     * @return string
     */
    public function getLoanId()
    {
        return $this->loanId;
    }
    /**
     * Set loanId value
     * @param string $loanId
     * @return \LendingQB\StructType\LendingQBSaveMismo23
     */
    public function setLoanId($loanId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($loanId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $loanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($loanId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loanId) && !is_string($loanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loanId)), __LINE__);
        }
        $this->loanId = $loanId;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBSaveMismo23
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sXmlData value
     * @return string|null
     */
    public function getSXmlData()
    {
        return $this->sXmlData;
    }
    /**
     * Set sXmlData value
     * @param string $sXmlData
     * @return \LendingQB\StructType\LendingQBSaveMismo23
     */
    public function setSXmlData($sXmlData = null)
    {
        // validation for constraint: string
        if (!is_null($sXmlData) && !is_string($sXmlData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sXmlData)), __LINE__);
        }
        $this->sXmlData = $sXmlData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBSaveMismo23
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
