<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Task ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBTask extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TaskEdit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBTaskEdit $parameters
     * @return \LendingQB\StructType\LendingQBTaskEditResponse|bool
     */
    public function TaskEdit(\LendingQB\StructType\LendingQBTaskEdit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TaskEdit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TaskResolve
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBTaskResolve $parameters
     * @return \LendingQB\StructType\LendingQBTaskResolveResponse|bool
     */
    public function TaskResolve(\LendingQB\StructType\LendingQBTaskResolve $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TaskResolve($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBTaskEditResponse|\LendingQB\StructType\LendingQBTaskResolveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
