<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Run ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBRun extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RunInternalPricing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRunInternalPricing $parameters
     * @return \LendingQB\StructType\LendingQBRunInternalPricingResponse|bool
     */
    public function RunInternalPricing(\LendingQB\StructType\LendingQBRunInternalPricing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RunInternalPricing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RunQuickPricer
     * Meta informations extracted from the WSDL
     * - documentation: [Deprecated] Please use the RunQuickPricerV1 method in QuickPricer.asmx instead, or upgrade to RunQuickPricerV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRunQuickPricer $parameters
     * @return \LendingQB\StructType\LendingQBRunQuickPricerResponse|bool
     */
    public function RunQuickPricer(\LendingQB\StructType\LendingQBRunQuickPricer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RunQuickPricer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RunQuickPricerForLockDesk
     * Meta informations extracted from the WSDL
     * - documentation: [Deprecated] Please use the RunQuickPricerV1ForLockDesk method in QuickPricer.asmx instead, or upgrade to RunQuickPricerV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRunQuickPricerForLockDesk $parameters
     * @return \LendingQB\StructType\LendingQBRunQuickPricerForLockDeskResponse|bool
     */
    public function RunQuickPricerForLockDesk(\LendingQB\StructType\LendingQBRunQuickPricerForLockDesk $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RunQuickPricerForLockDesk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBRunInternalPricingResponse|\LendingQB\StructType\LendingQBRunQuickPricerForLockDeskResponse|\LendingQB\StructType\LendingQBRunQuickPricerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
