<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBRegister extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * RegisterLoanProgramWithRateOptionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionId $parameters
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdResponse|bool
     */
    public function RegisterLoanProgramWithRateOptionId(\LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterLoanProgramWithRateOptionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterLoanProgram
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRegisterLoanProgram $parameters
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramResponse|bool
     */
    public function RegisterLoanProgram(\LendingQB\StructType\LendingQBRegisterLoanProgram $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterLoanProgram($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RegisterLoanProgramAndSkipDuplicateCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck $parameters
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheckResponse|bool
     */
    public function RegisterLoanProgramAndSkipDuplicateCheck(\LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterLoanProgramAndSkipDuplicateCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck $parameters
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheckResponse|bool
     */
    public function RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck(\LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterLoanProgramWithOptions
     * Meta informations extracted from the WSDL
     * - documentation: Registers a loan program. Options can be passed in using an LOXmlFormat payload.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRegisterLoanProgramWithOptions $parameters
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithOptionsResponse|bool
     */
    public function RegisterLoanProgramWithOptions(\LendingQB\StructType\LendingQBRegisterLoanProgramWithOptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterLoanProgramWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheckResponse|\LendingQB\StructType\LendingQBRegisterLoanProgramResponse|\LendingQB\StructType\LendingQBRegisterLoanProgramWithOptionsResponse|\LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheckResponse|\LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
