<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBLoad extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Load
     * Meta informations extracted from the WSDL
     * - documentation: Query data from a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The LendingQB Loan Name. [sXmlQuery] The Xml defines the list of fields to be included in the response. Refer to lo_xmlquery_blank.xml for an example.
     * [format] Identifies the output format to use. 0 - LO XML Query. 3 - Calyx Point (This is returned as an encoded base-64 Xml encased string. This is because the Calyx Point file is a binary file.) 4 - Fannie Mae 3.2. 9 - MISMO 2.6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLoad $parameters
     * @return \LendingQB\StructType\LendingQBLoadResponse|bool
     */
    public function Load(\LendingQB\StructType\LendingQBLoad $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Load($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadByRefNumber
     * Meta informations extracted from the WSDL
     * - documentation: Query data from a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLRefNm] The LendingQB Loan Reference Number. [sXmlQuery] The Xml defines the list of fields to be included in the response. Refer to lo_xmlquery_blank.xml
     * for an example. [format] Identifies the output format to use. 0 - LO XML Query. 3 - Calyx Point (This is returned as an encoded base-64 Xml encased string. This is because the Calyx Point file is a binary file.) 4 - Fannie Mae 3.2. 9 - MISMO 2.6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLoadByRefNumber $parameters
     * @return \LendingQB\StructType\LendingQBLoadByRefNumberResponse|bool
     */
    public function LoadByRefNumber(\LendingQB\StructType\LendingQBLoadByRefNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->LoadByRefNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMismo23ByLoanName
     * Meta informations extracted from the WSDL
     * - documentation: Load the loan identified by the sLNm in Mismo 2.3.1 Format. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The LendingQB Loan Name. [sXmlQuery] The Xml defines the list of fields to be included in the response. Refer to
     * lo_xmlquery_blank.xml for an example.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLoadMismo23ByLoanName $parameters
     * @return \LendingQB\StructType\LendingQBLoadMismo23ByLoanNameResponse|bool
     */
    public function LoadMismo23ByLoanName(\LendingQB\StructType\LendingQBLoadMismo23ByLoanName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->LoadMismo23ByLoanName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBLoadByRefNumberResponse|\LendingQB\StructType\LendingQBLoadMismo23ByLoanNameResponse|\LendingQB\StructType\LendingQBLoadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
