<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBIs extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IsLoanExisted
     * Meta informations extracted from the WSDL
     * - documentation: Returns a TRUE if the loan # exists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBIsLoanExisted $parameters
     * @return \LendingQB\StructType\LendingQBIsLoanExistedResponse|bool
     */
    public function IsLoanExisted(\LendingQB\StructType\LendingQBIsLoanExisted $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsLoanExisted($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBIsLoanExistedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
