<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBCreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateWithOptions
     * Meta informations extracted from the WSDL
     * - documentation: Create a new loan file and return a service result for the newly created loan.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateWithOptions $parameters
     * @return \LendingQB\StructType\LendingQBCreateWithOptionsResponse|bool
     */
    public function CreateWithOptions(\LendingQB\StructType\LendingQBCreateWithOptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Create
     * Meta informations extracted from the WSDL
     * - documentation: Create a new loan file and return a randomly generated loan name. [sTemplateNm] - The loan template number used to initialized the loan file. This value can be left blank.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreate $parameters
     * @return \LendingQB\StructType\LendingQBCreateResponse|bool
     */
    public function Create(\LendingQB\StructType\LendingQBCreate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLead
     * Meta informations extracted from the WSDL
     * - documentation: Create new lead and return a lead name.[sTemplateNm] - The loan template number used to initialized the lead file. This value can be left blank.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateLead $parameters
     * @return \LendingQB\StructType\LendingQBCreateLeadResponse|bool
     */
    public function CreateLead(\LendingQB\StructType\LendingQBCreateLead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateLead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWithULDD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateWithULDD $parameters
     * @return \LendingQB\StructType\LendingQBCreateWithULDDResponse|bool
     */
    public function CreateWithULDD(\LendingQB\StructType\LendingQBCreateWithULDD $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWithULDD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWithFannieMaeFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateWithFannieMaeFile $parameters
     * @return \LendingQB\StructType\LendingQBCreateWithFannieMaeFileResponse|bool
     */
    public function CreateWithFannieMaeFile(\LendingQB\StructType\LendingQBCreateWithFannieMaeFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWithFannieMaeFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWithCalyxPointFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateWithCalyxPointFile $parameters
     * @return \LendingQB\StructType\LendingQBCreateWithCalyxPointFileResponse|bool
     */
    public function CreateWithCalyxPointFile(\LendingQB\StructType\LendingQBCreateWithCalyxPointFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWithCalyxPointFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWithDesktopUnderwriter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateWithDesktopUnderwriter $parameters
     * @return \LendingQB\StructType\LendingQBCreateWithDesktopUnderwriterResponse|bool
     */
    public function CreateWithDesktopUnderwriter(\LendingQB\StructType\LendingQBCreateWithDesktopUnderwriter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWithDesktopUnderwriter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateClosingDisclosureArchiveByReferenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: Triggers the creation of a Closing Disclosure Archive for the loan file with the specified reference number. Returns XML containing the created archive's ID and status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber $parameters
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumberResponse|bool
     */
    public function CreateClosingDisclosureArchiveByReferenceNumber(\LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateClosingDisclosureArchiveByReferenceNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateClosingDisclosureArchive
     * Meta informations extracted from the WSDL
     * - documentation: Triggers the creation of a Closing Disclosure Archive for the specified loan file. Returns XML containing the created archive's ID and status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCreateClosingDisclosureArchive $parameters
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveResponse|bool
     */
    public function CreateClosingDisclosureArchive(\LendingQB\StructType\LendingQBCreateClosingDisclosureArchive $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateClosingDisclosureArchive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumberResponse|\LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveResponse|\LendingQB\StructType\LendingQBCreateLeadResponse|\LendingQB\StructType\LendingQBCreateResponse|\LendingQB\StructType\LendingQBCreateWithCalyxPointFileResponse|\LendingQB\StructType\LendingQBCreateWithDesktopUnderwriterResponse|\LendingQB\StructType\LendingQBCreateWithFannieMaeFileResponse|\LendingQB\StructType\LendingQBCreateWithOptionsResponse|\LendingQB\StructType\LendingQBCreateWithULDDResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
