<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBConvert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConvertLeadToLoan
     * Meta informations extracted from the WSDL
     * - documentation: Convert lead to loan and return a loan number. [sTicket] Ticket returned by AuthService.asmx. [sTemplateNm] - The loan template number used to initialized the lead file. [sLNm] The LendingQB Loan Name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBConvertLeadToLoan $parameters
     * @return \LendingQB\StructType\LendingQBConvertLeadToLoanResponse|bool
     */
    public function ConvertLeadToLoan(\LendingQB\StructType\LendingQBConvertLeadToLoan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConvertLeadToLoan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBConvertLeadToLoanResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
