<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clear ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBClear extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ClearModifiedLoansList
     * Meta informations extracted from the WSDL
     * - documentation: [OBSOLETE]. Use ClearModifiedLoansListByAppCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBClearModifiedLoansList $parameters
     * @return \LendingQB\StructType\LendingQBClearModifiedLoansListResponse|bool
     */
    public function ClearModifiedLoansList(\LendingQB\StructType\LendingQBClearModifiedLoansList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ClearModifiedLoansList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ClearModifiedLoansListByAppCode
     * Meta informations extracted from the WSDL
     * - documentation: Clear the list of recently modified loans with a Modified Date older than the [lastModifiedDate]
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBClearModifiedLoansListByAppCode $parameters
     * @return \LendingQB\StructType\LendingQBClearModifiedLoansListByAppCodeResponse|bool
     */
    public function ClearModifiedLoansListByAppCode(\LendingQB\StructType\LendingQBClearModifiedLoansListByAppCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ClearModifiedLoansListByAppCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ClearModifiedLoanByName
     * Meta informations extracted from the WSDL
     * - documentation: [OBSOLETE] Use ClearModifiedLoanByNameByAppCode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBClearModifiedLoanByName $parameters
     * @return \LendingQB\StructType\LendingQBClearModifiedLoanByNameResponse|bool
     */
    public function ClearModifiedLoanByName(\LendingQB\StructType\LendingQBClearModifiedLoanByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ClearModifiedLoanByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ClearModifiedLoanByNameByAppCode
     * Meta informations extracted from the WSDL
     * - documentation: Remove a particular loan name [loanName] from the list of recently modified loans.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBClearModifiedLoanByNameByAppCode $parameters
     * @return \LendingQB\StructType\LendingQBClearModifiedLoanByNameByAppCodeResponse|bool
     */
    public function ClearModifiedLoanByNameByAppCode(\LendingQB\StructType\LendingQBClearModifiedLoanByNameByAppCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ClearModifiedLoanByNameByAppCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBClearModifiedLoanByNameByAppCodeResponse|\LendingQB\StructType\LendingQBClearModifiedLoanByNameResponse|\LendingQB\StructType\LendingQBClearModifiedLoansListByAppCodeResponse|\LendingQB\StructType\LendingQBClearModifiedLoansListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
