<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBCheck extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckValidAppStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBCheckValidAppStatus $parameters
     * @return \LendingQB\StructType\LendingQBCheckValidAppStatusResponse|bool
     */
    public function CheckValidAppStatus(\LendingQB\StructType\LendingQBCheckValidAppStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CheckValidAppStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBCheckValidAppStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
