<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.lendingqb.com/los/webservice/Loan.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.lendingqb.com/los/webservice/Loan.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LendingQB\LendingQBClassMap::get(),
);
/**
 * Samples for Load ServiceType
 */
$load = new \LendingQB\ServiceType\LendingQBLoad($options);
/**
 * Sample call for Load operation/method
 */
if ($load->Load(new \LendingQB\StructType\LendingQBLoad()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadByRefNumber operation/method
 */
if ($load->LoadByRefNumber(new \LendingQB\StructType\LendingQBLoadByRefNumber()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMismo23ByLoanName operation/method
 */
if ($load->LoadMismo23ByLoanName(new \LendingQB\StructType\LendingQBLoadMismo23ByLoanName()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \LendingQB\ServiceType\LendingQBDelete($options);
/**
 * Sample call for DeleteApplicant operation/method
 */
if ($delete->DeleteApplicant(new \LendingQB\StructType\LendingQBDeleteApplicant()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLoan operation/method
 */
if ($delete->DeleteLoan(new \LendingQB\StructType\LendingQBDeleteLoan()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Parse ServiceType
 */
$parse = new \LendingQB\ServiceType\LendingQBParse($options);
/**
 * Sample call for ParseFnma32ToLoXml operation/method
 */
if ($parse->ParseFnma32ToLoXml(new \LendingQB\StructType\LendingQBParseFnma32ToLoXml()) !== false) {
    print_r($parse->getResult());
} else {
    print_r($parse->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \LendingQB\ServiceType\LendingQBUpload($options);
/**
 * Sample call for UploadPDFDocument operation/method
 */
if ($upload->UploadPDFDocument(new \LendingQB\StructType\LendingQBUploadPDFDocument()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentToApp operation/method
 */
if ($upload->UploadPDFDocumentToApp(new \LendingQB\StructType\LendingQBUploadPDFDocumentToApp()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentAsService operation/method
 */
if ($upload->UploadPDFDocumentAsService(new \LendingQB\StructType\LendingQBUploadPDFDocumentAsService()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadPDFDocumentToAppAsService operation/method
 */
if ($upload->UploadPDFDocumentToAppAsService(new \LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsService()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadLONXml operation/method
 */
if ($upload->UploadLONXml(new \LendingQB\StructType\LendingQBUploadLONXml()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \LendingQB\ServiceType\LendingQBSave($options);
/**
 * Sample call for Save operation/method
 */
if ($save->Save(new \LendingQB\StructType\LendingQBSave()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveByRefNumber operation/method
 */
if ($save->SaveByRefNumber(new \LendingQB\StructType\LendingQBSaveByRefNumber()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveMismo23 operation/method
 */
if ($save->SaveMismo23(new \LendingQB\StructType\LendingQBSaveMismo23()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \LendingQB\ServiceType\LendingQBIs($options);
/**
 * Sample call for IsLoanExisted operation/method
 */
if ($is->IsLoanExisted(new \LendingQB\StructType\LendingQBIsLoanExisted()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \LendingQB\ServiceType\LendingQBRetrieve($options);
/**
 * Sample call for RetrieveCustomReport operation/method
 */
if ($retrieve->RetrieveCustomReport(new \LendingQB\StructType\LendingQBRetrieveCustomReport()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveClosingCostTemplateFeeList operation/method
 */
if ($retrieve->RetrieveClosingCostTemplateFeeList(new \LendingQB\StructType\LendingQBRetrieveClosingCostTemplateFeeList()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveTaskById operation/method
 */
if ($retrieve->RetrieveTaskById(new \LendingQB\StructType\LendingQBRetrieveTaskById()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveUsersAssignedToLoan operation/method
 */
if ($retrieve->RetrieveUsersAssignedToLoan(new \LendingQB\StructType\LendingQBRetrieveUsersAssignedToLoan()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveRecentActiveLoanList operation/method
 */
if ($retrieve->RetrieveRecentActiveLoanList(new \LendingQB\StructType\LendingQBRetrieveRecentActiveLoanList()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveLoanActivityList operation/method
 */
if ($retrieve->RetrieveLoanActivityList(new \LendingQB\StructType\LendingQBRetrieveLoanActivityList()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrievePmlLoanList operation/method
 */
if ($retrieve->RetrievePmlLoanList(new \LendingQB\StructType\LendingQBRetrievePmlLoanList()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \LendingQB\ServiceType\LendingQBCreate($options);
/**
 * Sample call for CreateWithOptions operation/method
 */
if ($create->CreateWithOptions(new \LendingQB\StructType\LendingQBCreateWithOptions()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for Create operation/method
 */
if ($create->Create(new \LendingQB\StructType\LendingQBCreate()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateLead operation/method
 */
if ($create->CreateLead(new \LendingQB\StructType\LendingQBCreateLead()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWithULDD operation/method
 */
if ($create->CreateWithULDD(new \LendingQB\StructType\LendingQBCreateWithULDD()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWithFannieMaeFile operation/method
 */
if ($create->CreateWithFannieMaeFile(new \LendingQB\StructType\LendingQBCreateWithFannieMaeFile()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWithCalyxPointFile operation/method
 */
if ($create->CreateWithCalyxPointFile(new \LendingQB\StructType\LendingQBCreateWithCalyxPointFile()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWithDesktopUnderwriter operation/method
 */
if ($create->CreateWithDesktopUnderwriter(new \LendingQB\StructType\LendingQBCreateWithDesktopUnderwriter()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateClosingDisclosureArchiveByReferenceNumber operation/method
 */
if ($create->CreateClosingDisclosureArchiveByReferenceNumber(new \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateClosingDisclosureArchive operation/method
 */
if ($create->CreateClosingDisclosureArchive(new \LendingQB\StructType\LendingQBCreateClosingDisclosureArchive()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \LendingQB\ServiceType\LendingQBRegister($options);
/**
 * Sample call for RegisterLoanProgramWithRateOptionId operation/method
 */
if ($register->RegisterLoanProgramWithRateOptionId(new \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionId()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Sample call for RegisterLoanProgram operation/method
 */
if ($register->RegisterLoanProgram(new \LendingQB\StructType\LendingQBRegisterLoanProgram()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Sample call for RegisterLoanProgramAndSkipDuplicateCheck operation/method
 */
if ($register->RegisterLoanProgramAndSkipDuplicateCheck(new \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Sample call for RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
 * operation/method
 */
if ($register->RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck(new \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Sample call for RegisterLoanProgramWithOptions operation/method
 */
if ($register->RegisterLoanProgramWithOptions(new \LendingQB\StructType\LendingQBRegisterLoanProgramWithOptions()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Lock ServiceType
 */
$lock = new \LendingQB\ServiceType\LendingQBLock($options);
/**
 * Sample call for LockLoanProgramWithRateOptionId operation/method
 */
if ($lock->LockLoanProgramWithRateOptionId(new \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionId()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Sample call for LockLoanProgram operation/method
 */
if ($lock->LockLoanProgram(new \LendingQB\StructType\LendingQBLockLoanProgram()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Sample call for LockLoanProgramAndSkipDuplicateCheck operation/method
 */
if ($lock->LockLoanProgramAndSkipDuplicateCheck(new \LendingQB\StructType\LendingQBLockLoanProgramAndSkipDuplicateCheck()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Sample call for LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
 * operation/method
 */
if ($lock->LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck(new \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Sample call for LockLoanProgramWithOptions operation/method
 */
if ($lock->LockLoanProgramWithOptions(new \LendingQB\StructType\LendingQBLockLoanProgramWithOptions()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Samples for Break ServiceType
 */
$break = new \LendingQB\ServiceType\LendingQBBreak($options);
/**
 * Sample call for BreakBrokerRateLock operation/method
 */
if ($break->BreakBrokerRateLock(new \LendingQB\StructType\LendingQBBreakBrokerRateLock()) !== false) {
    print_r($break->getResult());
} else {
    print_r($break->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \LendingQB\ServiceType\LendingQBRemove($options);
/**
 * Sample call for RemoveRequestedRate operation/method
 */
if ($remove->RemoveRequestedRate(new \LendingQB\StructType\LendingQBRemoveRequestedRate()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \LendingQB\ServiceType\LendingQBList($options);
/**
 * Sample call for ListEdocsByLoanNumber operation/method
 */
if ($list->ListEdocsByLoanNumber(new \LendingQB\StructType\LendingQBListEdocsByLoanNumber()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListClosingCostTemplateName operation/method
 */
if ($list->ListClosingCostTemplateName(new \LendingQB\StructType\LendingQBListClosingCostTemplateName()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListModifiedLoans operation/method
 */
if ($list->ListModifiedLoans(new \LendingQB\StructType\LendingQBListModifiedLoans()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListModifiedLoansByAppCode operation/method
 */
if ($list->ListModifiedLoansByAppCode(new \LendingQB\StructType\LendingQBListModifiedLoansByAppCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListModifiedEDocsByAppCode operation/method
 */
if ($list->ListModifiedEDocsByAppCode(new \LendingQB\StructType\LendingQBListModifiedEDocsByAppCode()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListMyActiveTaskList operation/method
 */
if ($list->ListMyActiveTaskList(new \LendingQB\StructType\LendingQBListMyActiveTaskList()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Download ServiceType
 */
$download = new \LendingQB\ServiceType\LendingQBDownload($options);
/**
 * Sample call for DownloadEdocsPdfById operation/method
 */
if ($download->DownloadEdocsPdfById(new \LendingQB\StructType\LendingQBDownloadEdocsPdfById()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Sample call for DownloadEdocsByShippingTemplate operation/method
 */
if ($download->DownloadEdocsByShippingTemplate(new \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplate()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Samples for Prepare ServiceType
 */
$prepare = new \LendingQB\ServiceType\LendingQBPrepare($options);
/**
 * Sample call for PrepareLoanForResubmission operation/method
 */
if ($prepare->PrepareLoanForResubmission(new \LendingQB\StructType\LendingQBPrepareLoanForResubmission()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Samples for Clear ServiceType
 */
$clear = new \LendingQB\ServiceType\LendingQBClear($options);
/**
 * Sample call for ClearModifiedLoansList operation/method
 */
if ($clear->ClearModifiedLoansList(new \LendingQB\StructType\LendingQBClearModifiedLoansList()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Sample call for ClearModifiedLoansListByAppCode operation/method
 */
if ($clear->ClearModifiedLoansListByAppCode(new \LendingQB\StructType\LendingQBClearModifiedLoansListByAppCode()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Sample call for ClearModifiedLoanByName operation/method
 */
if ($clear->ClearModifiedLoanByName(new \LendingQB\StructType\LendingQBClearModifiedLoanByName()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Sample call for ClearModifiedLoanByNameByAppCode operation/method
 */
if ($clear->ClearModifiedLoanByNameByAppCode(new \LendingQB\StructType\LendingQBClearModifiedLoanByNameByAppCode()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Samples for Task ServiceType
 */
$task = new \LendingQB\ServiceType\LendingQBTask($options);
/**
 * Sample call for TaskEdit operation/method
 */
if ($task->TaskEdit(new \LendingQB\StructType\LendingQBTaskEdit()) !== false) {
    print_r($task->getResult());
} else {
    print_r($task->getLastError());
}
/**
 * Sample call for TaskResolve operation/method
 */
if ($task->TaskResolve(new \LendingQB\StructType\LendingQBTaskResolve()) !== false) {
    print_r($task->getResult());
} else {
    print_r($task->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \LendingQB\ServiceType\LendingQBGet($options);
/**
 * Sample call for GetPdfByLoanName operation/method
 */
if ($get->GetPdfByLoanName(new \LendingQB\StructType\LendingQBGetPdfByLoanName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDesktopUnderwriterCasefileStatusByLoanFile operation/method
 */
if ($get->GetDesktopUnderwriterCasefileStatusByLoanFile(new \LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusByLoanFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDesktopUnderwriterCasefileStatus operation/method
 */
if ($get->GetDesktopUnderwriterCasefileStatus(new \LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAuditLog operation/method
 */
if ($get->GetAuditLog(new \LendingQB\StructType\LendingQBGetAuditLog()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \LendingQB\ServiceType\LendingQBSearch($options);
/**
 * Sample call for Search operation/method
 */
if ($search->Search(new \LendingQB\StructType\LendingQBSearch()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Run ServiceType
 */
$run = new \LendingQB\ServiceType\LendingQBRun($options);
/**
 * Sample call for RunInternalPricing operation/method
 */
if ($run->RunInternalPricing(new \LendingQB\StructType\LendingQBRunInternalPricing()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Sample call for RunQuickPricer operation/method
 */
if ($run->RunQuickPricer(new \LendingQB\StructType\LendingQBRunQuickPricer()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Sample call for RunQuickPricerForLockDesk operation/method
 */
if ($run->RunQuickPricerForLockDesk(new \LendingQB\StructType\LendingQBRunQuickPricerForLockDesk()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \LendingQB\ServiceType\LendingQBSubmit($options);
/**
 * Sample call for SubmitTotalScorecard operation/method
 */
if ($submit->SubmitTotalScorecard(new \LendingQB\StructType\LendingQBSubmitTotalScorecard()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToLoanProspectorSeamless operation/method
 */
if ($submit->SubmitToLoanProspectorSeamless(new \LendingQB\StructType\LendingQBSubmitToLoanProspectorSeamless()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToFannieMaeEarlyCheck operation/method
 */
if ($submit->SubmitToFannieMaeEarlyCheck(new \LendingQB\StructType\LendingQBSubmitToFannieMaeEarlyCheck()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToDesktopUnderwriterSeamless operation/method
 */
if ($submit->SubmitToDesktopUnderwriterSeamless(new \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToDesktopUnderwriterSeamless_OptionalCredit
 * operation/method
 */
if ($submit->SubmitToDesktopUnderwriterSeamless_OptionalCredit(new \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless_OptionalCredit()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToDesktopUnderwriterSeamlessReissueCredit operation/method
 */
if ($submit->SubmitToDesktopUnderwriterSeamlessReissueCredit(new \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for
 * SubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport
 * operation/method
 */
if ($submit->SubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport(new \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToDesktopUnderwriterWithInstituteId operation/method
 */
if ($submit->SubmitToDesktopUnderwriterWithInstituteId(new \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterWithInstituteId()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToDesktopUnderwriter operation/method
 */
if ($submit->SubmitToDesktopUnderwriter(new \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriter()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for SubmitToDesktopOriginator operation/method
 */
if ($submit->SubmitToDesktopOriginator(new \LendingQB\StructType\LendingQBSubmitToDesktopOriginator()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \LendingQB\ServiceType\LendingQBImport($options);
/**
 * Sample call for ImportFromFreddieMac operation/method
 */
if ($import->ImportFromFreddieMac(new \LendingQB\StructType\LendingQBImportFromFreddieMac()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportFromFannieMaeWithInstitutionId operation/method
 */
if ($import->ImportFromFannieMaeWithInstitutionId(new \LendingQB\StructType\LendingQBImportFromFannieMaeWithInstitutionId()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportFromFannieMae operation/method
 */
if ($import->ImportFromFannieMae(new \LendingQB\StructType\LendingQBImportFromFannieMae()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \LendingQB\ServiceType\LendingQBCheck($options);
/**
 * Sample call for CheckValidAppStatus operation/method
 */
if ($check->CheckValidAppStatus(new \LendingQB\StructType\LendingQBCheckValidAppStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Recieve ServiceType
 */
$recieve = new \LendingQB\ServiceType\LendingQBRecieve($options);
/**
 * Sample call for RecievePdf operation/method
 */
if ($recieve->RecievePdf(new \LendingQB\StructType\LendingQBRecievePdf()) !== false) {
    print_r($recieve->getResult());
} else {
    print_r($recieve->getLastError());
}
/**
 * Samples for Document ServiceType
 */
$document = new \LendingQB\ServiceType\LendingQBDocument($options);
/**
 * Sample call for DocumentFrameworkGetAvailableDocPackagesAndPlanCodes
 * operation/method
 */
if ($document->DocumentFrameworkGetAvailableDocPackagesAndPlanCodes(new \LendingQB\StructType\LendingQBDocumentFrameworkGetAvailableDocPackagesAndPlanCodes()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
/**
 * Sample call for DocumentFrameworkPerformAudit operation/method
 */
if ($document->DocumentFrameworkPerformAudit(new \LendingQB\StructType\LendingQBDocumentFrameworkPerformAudit()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
/**
 * Sample call for DocumentFrameworkGetFormsList operation/method
 */
if ($document->DocumentFrameworkGetFormsList(new \LendingQB\StructType\LendingQBDocumentFrameworkGetFormsList()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
/**
 * Sample call for DocumentFrameworkGenerateDocs operation/method
 */
if ($document->DocumentFrameworkGenerateDocs(new \LendingQB\StructType\LendingQBDocumentFrameworkGenerateDocs()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
/**
 * Sample call for DocumentFrameworkDownloadGeneratedDocument operation/method
 */
if ($document->DocumentFrameworkDownloadGeneratedDocument(new \LendingQB\StructType\LendingQBDocumentFrameworkDownloadGeneratedDocument()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \LendingQB\ServiceType\LendingQBGenerate($options);
/**
 * Sample call for GenerateClosestCounselingOrganization operation/method
 */
if ($generate->GenerateClosestCounselingOrganization(new \LendingQB\StructType\LendingQBGenerateClosestCounselingOrganization()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Record ServiceType
 */
$record = new \LendingQB\ServiceType\LendingQBRecord($options);
/**
 * Sample call for RecordInitialDisclosureEventWithPartnerKey operation/method
 */
if ($record->RecordInitialDisclosureEventWithPartnerKey(new \LendingQB\StructType\LendingQBRecordInitialDisclosureEventWithPartnerKey()) !== false) {
    print_r($record->getResult());
} else {
    print_r($record->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \LendingQB\ServiceType\LendingQBConvert($options);
/**
 * Sample call for ConvertLeadToLoan operation/method
 */
if ($convert->ConvertLeadToLoan(new \LendingQB\StructType\LendingQBConvertLeadToLoan()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
