<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
 * StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck extends AbstractStructBase
{
    /**
     * The requestedRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedRate;
    /**
     * The requestedFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedFee;
    /**
     * The skipDuplicateCheck
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $skipDuplicateCheck;
    /**
     * The sTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sLNm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The lLpTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lLpTemplateId;
    /**
     * The rateOptionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rateOptionId;
    /**
     * Constructor method for RegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setRequestedRate()
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setRequestedFee()
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setSkipDuplicateCheck()
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setSTicket()
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setSLNm()
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setLLpTemplateId()
     * @uses LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setRateOptionId()
     * @param float $requestedRate
     * @param float $requestedFee
     * @param bool $skipDuplicateCheck
     * @param string $sTicket
     * @param string $sLNm
     * @param string $lLpTemplateId
     * @param string $rateOptionId
     */
    public function __construct($requestedRate = null, $requestedFee = null, $skipDuplicateCheck = null, $sTicket = null, $sLNm = null, $lLpTemplateId = null, $rateOptionId = null)
    {
        $this
            ->setRequestedRate($requestedRate)
            ->setRequestedFee($requestedFee)
            ->setSkipDuplicateCheck($skipDuplicateCheck)
            ->setSTicket($sTicket)
            ->setSLNm($sLNm)
            ->setLLpTemplateId($lLpTemplateId)
            ->setRateOptionId($rateOptionId);
    }
    /**
     * Get requestedRate value
     * @return float
     */
    public function getRequestedRate()
    {
        return $this->requestedRate;
    }
    /**
     * Set requestedRate value
     * @param float $requestedRate
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setRequestedRate($requestedRate = null)
    {
        $this->requestedRate = $requestedRate;
        return $this;
    }
    /**
     * Get requestedFee value
     * @return float
     */
    public function getRequestedFee()
    {
        return $this->requestedFee;
    }
    /**
     * Set requestedFee value
     * @param float $requestedFee
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setRequestedFee($requestedFee = null)
    {
        $this->requestedFee = $requestedFee;
        return $this;
    }
    /**
     * Get skipDuplicateCheck value
     * @return bool
     */
    public function getSkipDuplicateCheck()
    {
        return $this->skipDuplicateCheck;
    }
    /**
     * Set skipDuplicateCheck value
     * @param bool $skipDuplicateCheck
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setSkipDuplicateCheck($skipDuplicateCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipDuplicateCheck) && !is_bool($skipDuplicateCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($skipDuplicateCheck)), __LINE__);
        }
        $this->skipDuplicateCheck = $skipDuplicateCheck;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get lLpTemplateId value
     * @return string|null
     */
    public function getLLpTemplateId()
    {
        return $this->lLpTemplateId;
    }
    /**
     * Set lLpTemplateId value
     * @param string $lLpTemplateId
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setLLpTemplateId($lLpTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($lLpTemplateId) && !is_string($lLpTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lLpTemplateId)), __LINE__);
        }
        $this->lLpTemplateId = $lLpTemplateId;
        return $this;
    }
    /**
     * Get rateOptionId value
     * @return string|null
     */
    public function getRateOptionId()
    {
        return $this->rateOptionId;
    }
    /**
     * Set rateOptionId value
     * @param string $rateOptionId
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setRateOptionId($rateOptionId = null)
    {
        // validation for constraint: string
        if (!is_null($rateOptionId) && !is_string($rateOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateOptionId)), __LINE__);
        }
        $this->rateOptionId = $rateOptionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
