<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterLoanProgramAndSkipDuplicateCheck StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBRegisterLoanProgramAndSkipDuplicateCheck extends AbstractStructBase
{
    /**
     * The requestedRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedRate;
    /**
     * The requestedFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedFee;
    /**
     * The skipDuplicateCheck
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $skipDuplicateCheck;
    /**
     * The sTicket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sLNm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The lLpTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lLpTemplateId;
    /**
     * Constructor method for RegisterLoanProgramAndSkipDuplicateCheck
     * @uses LendingQBRegisterLoanProgramAndSkipDuplicateCheck::setRequestedRate()
     * @uses LendingQBRegisterLoanProgramAndSkipDuplicateCheck::setRequestedFee()
     * @uses LendingQBRegisterLoanProgramAndSkipDuplicateCheck::setSkipDuplicateCheck()
     * @uses LendingQBRegisterLoanProgramAndSkipDuplicateCheck::setSTicket()
     * @uses LendingQBRegisterLoanProgramAndSkipDuplicateCheck::setSLNm()
     * @uses LendingQBRegisterLoanProgramAndSkipDuplicateCheck::setLLpTemplateId()
     * @param float $requestedRate
     * @param float $requestedFee
     * @param bool $skipDuplicateCheck
     * @param string $sTicket
     * @param string $sLNm
     * @param string $lLpTemplateId
     */
    public function __construct($requestedRate = null, $requestedFee = null, $skipDuplicateCheck = null, $sTicket = null, $sLNm = null, $lLpTemplateId = null)
    {
        $this
            ->setRequestedRate($requestedRate)
            ->setRequestedFee($requestedFee)
            ->setSkipDuplicateCheck($skipDuplicateCheck)
            ->setSTicket($sTicket)
            ->setSLNm($sLNm)
            ->setLLpTemplateId($lLpTemplateId);
    }
    /**
     * Get requestedRate value
     * @return float
     */
    public function getRequestedRate()
    {
        return $this->requestedRate;
    }
    /**
     * Set requestedRate value
     * @param float $requestedRate
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public function setRequestedRate($requestedRate = null)
    {
        $this->requestedRate = $requestedRate;
        return $this;
    }
    /**
     * Get requestedFee value
     * @return float
     */
    public function getRequestedFee()
    {
        return $this->requestedFee;
    }
    /**
     * Set requestedFee value
     * @param float $requestedFee
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public function setRequestedFee($requestedFee = null)
    {
        $this->requestedFee = $requestedFee;
        return $this;
    }
    /**
     * Get skipDuplicateCheck value
     * @return bool
     */
    public function getSkipDuplicateCheck()
    {
        return $this->skipDuplicateCheck;
    }
    /**
     * Set skipDuplicateCheck value
     * @param bool $skipDuplicateCheck
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public function setSkipDuplicateCheck($skipDuplicateCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipDuplicateCheck) && !is_bool($skipDuplicateCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($skipDuplicateCheck)), __LINE__);
        }
        $this->skipDuplicateCheck = $skipDuplicateCheck;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get lLpTemplateId value
     * @return string|null
     */
    public function getLLpTemplateId()
    {
        return $this->lLpTemplateId;
    }
    /**
     * Set lLpTemplateId value
     * @param string $lLpTemplateId
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public function setLLpTemplateId($lLpTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($lLpTemplateId) && !is_string($lLpTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lLpTemplateId)), __LINE__);
        }
        $this->lLpTemplateId = $lLpTemplateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgramAndSkipDuplicateCheck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
