<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBRetrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveCustomReport
     * Meta informations extracted from the WSDL
     * - documentation: This method is deprecated. Please use the RetrieveCustomReport method in Reporting.asmx instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrieveCustomReport $parameters
     * @return \LendingQB\StructType\LendingQBRetrieveCustomReportResponse|bool
     */
    public function RetrieveCustomReport(\LendingQB\StructType\LendingQBRetrieveCustomReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveCustomReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveClosingCostTemplateFeeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrieveClosingCostTemplateFeeList $parameters
     * @return \LendingQB\StructType\LendingQBRetrieveClosingCostTemplateFeeListResponse|bool
     */
    public function RetrieveClosingCostTemplateFeeList(\LendingQB\StructType\LendingQBRetrieveClosingCostTemplateFeeList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveClosingCostTemplateFeeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveTaskById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrieveTaskById $parameters
     * @return \LendingQB\StructType\LendingQBRetrieveTaskByIdResponse|bool
     */
    public function RetrieveTaskById(\LendingQB\StructType\LendingQBRetrieveTaskById $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveTaskById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveUsersAssignedToLoan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrieveUsersAssignedToLoan $parameters
     * @return \LendingQB\StructType\LendingQBRetrieveUsersAssignedToLoanResponse|bool
     */
    public function RetrieveUsersAssignedToLoan(\LendingQB\StructType\LendingQBRetrieveUsersAssignedToLoan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveUsersAssignedToLoan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveRecentActiveLoanList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrieveRecentActiveLoanList $parameters
     * @return \LendingQB\StructType\LendingQBRetrieveRecentActiveLoanListResponse|bool
     */
    public function RetrieveRecentActiveLoanList(\LendingQB\StructType\LendingQBRetrieveRecentActiveLoanList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveRecentActiveLoanList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveLoanActivityList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrieveLoanActivityList $parameters
     * @return \LendingQB\StructType\LendingQBRetrieveLoanActivityListResponse|bool
     */
    public function RetrieveLoanActivityList(\LendingQB\StructType\LendingQBRetrieveLoanActivityList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveLoanActivityList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrievePmlLoanList
     * Meta informations extracted from the WSDL
     * - documentation: This method returns an XML containing the list of loan files accessible to a PML user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRetrievePmlLoanList $parameters
     * @return \LendingQB\StructType\LendingQBRetrievePmlLoanListResponse|bool
     */
    public function RetrievePmlLoanList(\LendingQB\StructType\LendingQBRetrievePmlLoanList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrievePmlLoanList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBRetrieveClosingCostTemplateFeeListResponse|\LendingQB\StructType\LendingQBRetrieveCustomReportResponse|\LendingQB\StructType\LendingQBRetrieveLoanActivityListResponse|\LendingQB\StructType\LendingQBRetrievePmlLoanListResponse|\LendingQB\StructType\LendingQBRetrieveRecentActiveLoanListResponse|\LendingQB\StructType\LendingQBRetrieveTaskByIdResponse|\LendingQB\StructType\LendingQBRetrieveUsersAssignedToLoanResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
