<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Download ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBDownload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DownloadEdocsPdfById
     * Meta informations extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDownloadEdocsPdfById $parameters
     * @return \LendingQB\StructType\LendingQBDownloadEdocsPdfByIdResponse|bool
     */
    public function DownloadEdocsPdfById(\LendingQB\StructType\LendingQBDownloadEdocsPdfById $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DownloadEdocsPdfById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadEdocsByShippingTemplate
     * Meta informations extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead. This method returns a PDF containing EDocs on the given loan file [sLNm] that are included in the shipping template [sShippingTemplateName]. EDocs with
     * Protected status are included by default. Obsolete/Rejected docs are omitted. Does not preserve electronic signatures.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplate $parameters
     * @return \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplateResponse|bool
     */
    public function DownloadEdocsByShippingTemplate(\LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DownloadEdocsByShippingTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBDownloadEdocsByShippingTemplateResponse|\LendingQB\StructType\LendingQBDownloadEdocsPdfByIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
