<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Document ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBDocument extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * DocumentFrameworkGetAvailableDocPackagesAndPlanCodes
     * Meta informations extracted from the WSDL
     * - documentation: Loads available document packages and plan codes for given loan through the LQB Document Framework. AccountId may be empty if not required by the document vendor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDocumentFrameworkGetAvailableDocPackagesAndPlanCodes $parameters
     * @return \LendingQB\StructType\LendingQBDocumentFrameworkGetAvailableDocPackagesAndPlanCodesResponse|bool
     */
    public function DocumentFrameworkGetAvailableDocPackagesAndPlanCodes(\LendingQB\StructType\LendingQBDocumentFrameworkGetAvailableDocPackagesAndPlanCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DocumentFrameworkGetAvailableDocPackagesAndPlanCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DocumentFrameworkPerformAudit
     * Meta informations extracted from the WSDL
     * - documentation: Requests an audit through the LQB Document Framework. AccountId may be empty if not required by the document vendor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDocumentFrameworkPerformAudit $parameters
     * @return \LendingQB\StructType\LendingQBDocumentFrameworkPerformAuditResponse|bool
     */
    public function DocumentFrameworkPerformAudit(\LendingQB\StructType\LendingQBDocumentFrameworkPerformAudit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DocumentFrameworkPerformAudit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DocumentFrameworkGetFormsList
     * Meta informations extracted from the WSDL
     * - documentation: Requests a list of individual forms that can be generated at document request via LQB Document Framework.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDocumentFrameworkGetFormsList $parameters
     * @return \LendingQB\StructType\LendingQBDocumentFrameworkGetFormsListResponse|bool
     */
    public function DocumentFrameworkGetFormsList(\LendingQB\StructType\LendingQBDocumentFrameworkGetFormsList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DocumentFrameworkGetFormsList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DocumentFrameworkGenerateDocs
     * Meta informations extracted from the WSDL
     * - documentation: Generates Documents via LQB Document Framework.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDocumentFrameworkGenerateDocs $parameters
     * @return \LendingQB\StructType\LendingQBDocumentFrameworkGenerateDocsResponse|bool
     */
    public function DocumentFrameworkGenerateDocs(\LendingQB\StructType\LendingQBDocumentFrameworkGenerateDocs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DocumentFrameworkGenerateDocs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DocumentFrameworkDownloadGeneratedDocument
     * Meta informations extracted from the WSDL
     * - documentation: Downloads the generated documents using the download key provided in DocumentFrameworkGenerateDocs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDocumentFrameworkDownloadGeneratedDocument $parameters
     * @return \LendingQB\StructType\LendingQBDocumentFrameworkDownloadGeneratedDocumentResponse|bool
     */
    public function DocumentFrameworkDownloadGeneratedDocument(\LendingQB\StructType\LendingQBDocumentFrameworkDownloadGeneratedDocument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DocumentFrameworkDownloadGeneratedDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBDocumentFrameworkDownloadGeneratedDocumentResponse|\LendingQB\StructType\LendingQBDocumentFrameworkGenerateDocsResponse|\LendingQB\StructType\LendingQBDocumentFrameworkGetAvailableDocPackagesAndPlanCodesResponse|\LendingQB\StructType\LendingQBDocumentFrameworkGetFormsListResponse|\LendingQB\StructType\LendingQBDocumentFrameworkPerformAuditResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
