<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBDelete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteApplicant
     * Meta informations extracted from the WSDL
     * - documentation: Delete an applicant from an application. [sTicket] Ticket returned by AuthServices.asmx. [sLNm] The LendingQB Loan Name. [applicantSSN] The SSN of the borrower/coborrower we'll delete.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDeleteApplicant $parameters
     * @return \LendingQB\StructType\LendingQBDeleteApplicantResponse|bool
     */
    public function DeleteApplicant(\LendingQB\StructType\LendingQBDeleteApplicant $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteApplicant($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLoan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBDeleteLoan $parameters
     * @return \LendingQB\StructType\LendingQBDeleteLoanResponse|bool
     */
    public function DeleteLoan(\LendingQB\StructType\LendingQBDeleteLoan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteLoan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBDeleteApplicantResponse|\LendingQB\StructType\LendingQBDeleteLoanResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
