<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Break ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBBreak extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BreakBrokerRateLock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBBreakBrokerRateLock $parameters
     * @return \LendingQB\StructType\LendingQBBreakBrokerRateLockResponse|bool
     */
    public function BreakBrokerRateLock(\LendingQB\StructType\LendingQBBreakBrokerRateLock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BreakBrokerRateLock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBBreakBrokerRateLockResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
