<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadLONXml StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadLONXml extends AbstractStructBase
{
    /**
     * The loanId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $loanId;
    /**
     * The sTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sXmlData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sXmlData;
    /**
     * Constructor method for UploadLONXml
     * @uses LendingQBUploadLONXml::setLoanId()
     * @uses LendingQBUploadLONXml::setSTicket()
     * @uses LendingQBUploadLONXml::setSXmlData()
     * @param string $loanId
     * @param string $sTicket
     * @param string $sXmlData
     */
    public function __construct($loanId = null, $sTicket = null, $sXmlData = null)
    {
        $this
            ->setLoanId($loanId)
            ->setSTicket($sTicket)
            ->setSXmlData($sXmlData);
    }
    /**
     * Get loanId value
     * @return string
     */
    public function getLoanId()
    {
        return $this->loanId;
    }
    /**
     * Set loanId value
     * @param string $loanId
     * @return \LendingQB\StructType\LendingQBUploadLONXml
     */
    public function setLoanId($loanId = null)
    {
        // validation for constraint: string
        if (!is_null($loanId) && !is_string($loanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanId, true), gettype($loanId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($loanId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $loanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($loanId, true)), __LINE__);
        }
        $this->loanId = $loanId;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBUploadLONXml
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTicket, true), gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sXmlData value
     * @return string|null
     */
    public function getSXmlData()
    {
        return $this->sXmlData;
    }
    /**
     * Set sXmlData value
     * @param string $sXmlData
     * @return \LendingQB\StructType\LendingQBUploadLONXml
     */
    public function setSXmlData($sXmlData = null)
    {
        // validation for constraint: string
        if (!is_null($sXmlData) && !is_string($sXmlData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sXmlData, true), gettype($sXmlData)), __LINE__);
        }
        $this->sXmlData = $sXmlData;
        return $this;
    }
}
