<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterLoanProgram StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBRegisterLoanProgram extends AbstractStructBase
{
    /**
     * The requestedRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedRate;
    /**
     * The requestedFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedFee;
    /**
     * The sTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sLNm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The lLpTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lLpTemplateId;
    /**
     * Constructor method for RegisterLoanProgram
     * @uses LendingQBRegisterLoanProgram::setRequestedRate()
     * @uses LendingQBRegisterLoanProgram::setRequestedFee()
     * @uses LendingQBRegisterLoanProgram::setSTicket()
     * @uses LendingQBRegisterLoanProgram::setSLNm()
     * @uses LendingQBRegisterLoanProgram::setLLpTemplateId()
     * @param float $requestedRate
     * @param float $requestedFee
     * @param string $sTicket
     * @param string $sLNm
     * @param string $lLpTemplateId
     */
    public function __construct($requestedRate = null, $requestedFee = null, $sTicket = null, $sLNm = null, $lLpTemplateId = null)
    {
        $this
            ->setRequestedRate($requestedRate)
            ->setRequestedFee($requestedFee)
            ->setSTicket($sTicket)
            ->setSLNm($sLNm)
            ->setLLpTemplateId($lLpTemplateId);
    }
    /**
     * Get requestedRate value
     * @return float
     */
    public function getRequestedRate()
    {
        return $this->requestedRate;
    }
    /**
     * Set requestedRate value
     * @param float $requestedRate
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgram
     */
    public function setRequestedRate($requestedRate = null)
    {
        // validation for constraint: float
        if (!is_null($requestedRate) && !(is_float($requestedRate) || is_numeric($requestedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedRate, true), gettype($requestedRate)), __LINE__);
        }
        $this->requestedRate = $requestedRate;
        return $this;
    }
    /**
     * Get requestedFee value
     * @return float
     */
    public function getRequestedFee()
    {
        return $this->requestedFee;
    }
    /**
     * Set requestedFee value
     * @param float $requestedFee
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgram
     */
    public function setRequestedFee($requestedFee = null)
    {
        // validation for constraint: float
        if (!is_null($requestedFee) && !(is_float($requestedFee) || is_numeric($requestedFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedFee, true), gettype($requestedFee)), __LINE__);
        }
        $this->requestedFee = $requestedFee;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgram
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTicket, true), gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgram
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLNm, true), gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get lLpTemplateId value
     * @return string|null
     */
    public function getLLpTemplateId()
    {
        return $this->lLpTemplateId;
    }
    /**
     * Set lLpTemplateId value
     * @param string $lLpTemplateId
     * @return \LendingQB\StructType\LendingQBRegisterLoanProgram
     */
    public function setLLpTemplateId($lLpTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($lLpTemplateId) && !is_string($lLpTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lLpTemplateId, true), gettype($lLpTemplateId)), __LINE__);
        }
        $this->lLpTemplateId = $lLpTemplateId;
        return $this;
    }
}
