<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Load StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBLoad extends AbstractStructBase
{
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $format;
    /**
     * The sTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sLNm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The sXmlQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sXmlQuery;
    /**
     * Constructor method for Load
     * @uses LendingQBLoad::setFormat()
     * @uses LendingQBLoad::setSTicket()
     * @uses LendingQBLoad::setSLNm()
     * @uses LendingQBLoad::setSXmlQuery()
     * @param int $format
     * @param string $sTicket
     * @param string $sLNm
     * @param string $sXmlQuery
     */
    public function __construct($format = null, $sTicket = null, $sLNm = null, $sXmlQuery = null)
    {
        $this
            ->setFormat($format)
            ->setSTicket($sTicket)
            ->setSLNm($sLNm)
            ->setSXmlQuery($sXmlQuery);
    }
    /**
     * Get format value
     * @return int
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param int $format
     * @return \LendingQB\StructType\LendingQBLoad
     */
    public function setFormat($format = null)
    {
        // validation for constraint: int
        if (!is_null($format) && !(is_int($format) || ctype_digit($format))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBLoad
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTicket, true), gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBLoad
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLNm, true), gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get sXmlQuery value
     * @return string|null
     */
    public function getSXmlQuery()
    {
        return $this->sXmlQuery;
    }
    /**
     * Set sXmlQuery value
     * @param string $sXmlQuery
     * @return \LendingQB\StructType\LendingQBLoad
     */
    public function setSXmlQuery($sXmlQuery = null)
    {
        // validation for constraint: string
        if (!is_null($sXmlQuery) && !is_string($sXmlQuery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sXmlQuery, true), gettype($sXmlQuery)), __LINE__);
        }
        $this->sXmlQuery = $sXmlQuery;
        return $this;
    }
}
