<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBUpload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadPDFDocument
     * Meta information extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead. Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [documentType] The PDF document type name.
     * [notes] Notes related to the PDF document. [sDataContent] The base 64 encoded PDF document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocument $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentResponse|bool
     */
    public function UploadPDFDocument(\LendingQB\StructType\LendingQBUploadPDFDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocumentToApp
     * Meta information extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead. Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [aAppId] The Application Id to contain the
     * file. [documentType] The PDF document type name. [notes] Notes related to the PDF document. [sDataContent] The base 64 encoded PDF document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentToApp $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToAppResponse|bool
     */
    public function UploadPDFDocumentToApp(\LendingQB\StructType\LendingQBUploadPDFDocumentToApp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentToApp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocumentAsService
     * Meta information extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead. Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [documentType] The PDF document type name.
     * [notes] Notes related to the PDF document. [sDataContent] The base 64 encoded PDF document. [serviceType] The type of service currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentAsService $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentAsServiceResponse|bool
     */
    public function UploadPDFDocumentAsService(\LendingQB\StructType\LendingQBUploadPDFDocumentAsService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentAsService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadPDFDocumentToAppAsService
     * Meta information extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead. Add a PDF to a loan file. [sTicket] Ticket returned by AuthService.asmx. [sLNm] The MeridianLink Mortgage Loan Name. [aAppId] The Application Id to contain the
     * file. [documentType] The PDF document type name. [notes] Notes related to the PDF document. [sDataContent] The base 64 encoded PDF document. [serviceType] The type of service currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsService $parameters
     * @return \LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsServiceResponse|bool
     */
    public function UploadPDFDocumentToAppAsService(\LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadPDFDocumentToAppAsService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadLONXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadLONXml $parameters
     * @return \LendingQB\StructType\LendingQBUploadLONXmlResponse|bool
     */
    public function UploadLONXml(\LendingQB\StructType\LendingQBUploadLONXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadLONXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UploadConsumerDocumentRequestDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocument $parameters
     * @return \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocumentResponse|bool
     */
    public function UploadConsumerDocumentRequestDocument(\LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadConsumerDocumentRequestDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocumentResponse|\LendingQB\StructType\LendingQBUploadLONXmlResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentAsServiceResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentToAppAsServiceResponse|\LendingQB\StructType\LendingQBUploadPDFDocumentToAppResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
