<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfer ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBTransfer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransferULADApplication
     * Meta information extracted from the WSDL
     * - documentation: Transfers the specified ULAD application to a different position on the loan file. [sTicket] Ticket returned by AuthServices.asmx. [optionsXml] LoXml with loanid / loan reference number / loan number, uladapplicationid, index.
     * [returns] xml.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBTransferULADApplication $parameters
     * @return \LendingQB\StructType\LendingQBTransferULADApplicationResponse|bool
     */
    public function TransferULADApplication(\LendingQB\StructType\LendingQBTransferULADApplication $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferULADApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferLegacyApplication
     * Meta information extracted from the WSDL
     * - documentation: Transfer a legacy application between ULAD applications. [sTicket] Ticket returned by AuthServices.asmx. [optionsXml] LoXml with loanid / loan reference number / loan number, legacyapplicationid, index, and optionally
     * uladapplicationid. [returns] xml which may or may not have a CreatedUladApplicationId.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBTransferLegacyApplication $parameters
     * @return \LendingQB\StructType\LendingQBTransferLegacyApplicationResponse|bool
     */
    public function TransferLegacyApplication(\LendingQB\StructType\LendingQBTransferLegacyApplication $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferLegacyApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBTransferLegacyApplicationResponse|\LendingQB\StructType\LendingQBTransferULADApplicationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
