<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBRemove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RemoveBorrower
     * Meta information extracted from the WSDL
     * - documentation: Removes the specified borrower. [sTicket] Ticket returned by AuthServices.asmx. [optionsXml] LoXml with loanid/ loan reference number / loan number, borrowerid. [returns] xml which if successful has properties SwappedBorrower,
     * DeletedLegacyApplicationId, DeletedUladApplicationId.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRemoveBorrower $parameters
     * @return \LendingQB\StructType\LendingQBRemoveBorrowerResponse|bool
     */
    public function RemoveBorrower(\LendingQB\StructType\LendingQBRemoveBorrower $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveBorrower($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveRequestedRate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRemoveRequestedRate $parameters
     * @return \LendingQB\StructType\LendingQBRemoveRequestedRateResponse|bool
     */
    public function RemoveRequestedRate(\LendingQB\StructType\LendingQBRemoveRequestedRate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveRequestedRate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBRemoveBorrowerResponse|\LendingQB\StructType\LendingQBRemoveRequestedRateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
