<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Record ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBRecord extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * RecordInitialDisclosureEventWithPartnerKey
     * Meta information extracted from the WSDL
     * - documentation: Allows users to record an initial disclosure in the system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRecordInitialDisclosureEventWithPartnerKey $parameters
     * @return \LendingQB\StructType\LendingQBRecordInitialDisclosureEventWithPartnerKeyResponse|bool
     */
    public function RecordInitialDisclosureEventWithPartnerKey(\LendingQB\StructType\LendingQBRecordInitialDisclosureEventWithPartnerKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecordInitialDisclosureEventWithPartnerKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBRecordInitialDisclosureEventWithPartnerKeyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
